/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;

public class Canvas
implements ImageFilter {
    private final int width;
    private final int height;
    private final Position position;
    private final Color fillColor;
    private final boolean crop;

    public Canvas(int width, int height, Position position) {
        this(width, height, position, true, null);
    }

    public Canvas(int width, int height, Position position, boolean crop) {
        this(width, height, position, crop, null);
    }

    public Canvas(int width, int height, Position position, Color fillColor) {
        this(width, height, position, true, fillColor);
    }

    public Canvas(int width, int height, Position position, boolean crop, Color fillColor) {
        this.width = width;
        this.height = height;
        this.position = position;
        this.crop = crop;
        this.fillColor = fillColor;
    }

    @Override
    public BufferedImage apply(BufferedImage img) {
        int widthToUse = this.width;
        int heightToUse = this.height;
        if (!this.crop && img.getWidth() > this.width) {
            widthToUse = img.getWidth();
        }
        if (!this.crop && img.getHeight() > this.height) {
            heightToUse = img.getHeight();
        }
        Point p = this.position.calculate(widthToUse, heightToUse, img.getWidth(), img.getHeight(), 0, 0, 0, 0);
        BufferedImage finalImage = new BufferedImage(widthToUse, heightToUse, img.getType());
        Graphics g = finalImage.getGraphics();
        if (this.fillColor == null && !img.getColorModel().hasAlpha()) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.width, this.height);
        } else if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fillRect(0, 0, widthToUse, heightToUse);
        }
        g.drawImage(img, p.x, p.y, null);
        g.dispose();
        return finalImage;
    }
}

