/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.util.BufferedImages;

public class Caption
implements ImageFilter {
    private final String caption;
    private final Font font;
    private final Color c;
    private final float alpha;
    private final Position position;
    private final int insets;

    public Caption(String caption, Font font, Color c, float alpha, Position position, int insets) {
        this.caption = caption;
        this.font = font;
        this.c = c;
        this.alpha = alpha;
        this.position = position;
        this.insets = insets;
    }

    public Caption(String caption, Font font, Color c, Position position, int insets) {
        this.caption = caption;
        this.font = font;
        this.c = c;
        this.alpha = 1.0f;
        this.position = position;
        this.insets = insets;
    }

    @Override
    public BufferedImage apply(BufferedImage img) {
        BufferedImage newImage = BufferedImages.copy(img);
        Graphics2D g = newImage.createGraphics();
        g.setFont(this.font);
        g.setColor(this.c);
        g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int imageWidth = img.getWidth();
        int imageHeight = img.getHeight();
        int captionWidth = g.getFontMetrics().stringWidth(this.caption);
        int captionHeight = g.getFontMetrics().getHeight() / 2;
        Point p = this.position.calculate(imageWidth, imageHeight, captionWidth, 0, this.insets, this.insets, this.insets, this.insets);
        double yRatio = (double)p.y / (double)img.getHeight();
        int yOffset = (int)((1.0 - yRatio) * (double)captionHeight);
        g.drawString(this.caption, p.x, p.y + yOffset);
        g.dispose();
        return newImage;
    }
}

