/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.util.BufferedImages;

public final class Pipeline
implements ImageFilter {
    private final List<ImageFilter> filtersToApply;
    private final List<ImageFilter> unmodifiableFiltersToApply;

    public Pipeline() {
        this(Collections.emptyList());
    }

    public Pipeline(ImageFilter ... filters) {
        this(Arrays.asList(filters));
    }

    public Pipeline(List<ImageFilter> filters) {
        if (filters == null) {
            throw new NullPointerException("Cannot instantiate with a nulllist of image filters.");
        }
        this.filtersToApply = new ArrayList<ImageFilter>(filters);
        this.unmodifiableFiltersToApply = Collections.unmodifiableList(this.filtersToApply);
    }

    public void add(ImageFilter filter) {
        if (filter == null) {
            throw new NullPointerException("An image filter must not be null.");
        }
        this.filtersToApply.add(filter);
    }

    public void addFirst(ImageFilter filter) {
        if (filter == null) {
            throw new NullPointerException("An image filter must not be null.");
        }
        this.filtersToApply.add(0, filter);
    }

    public void addAll(List<ImageFilter> filters) {
        if (filters == null) {
            throw new NullPointerException("A list of image filters must not be null.");
        }
        this.filtersToApply.addAll(filters);
    }

    public List<ImageFilter> getFilters() {
        return this.unmodifiableFiltersToApply;
    }

    @Override
    public BufferedImage apply(BufferedImage img) {
        if (this.filtersToApply.isEmpty()) {
            return img;
        }
        BufferedImage image = BufferedImages.copy(img);
        for (ImageFilter filter : this.filtersToApply) {
            image = filter.apply(image);
        }
        return image;
    }
}

