/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.geometry;

import java.awt.Dimension;
import net.coobird.thumbnailator.geometry.Size;

public class AbsoluteSize
implements Size {
    private final Dimension size;

    public AbsoluteSize(Dimension size) {
        if (size == null) {
            throw new NullPointerException("Size cannot be null.");
        }
        this.size = new Dimension(size);
    }

    public AbsoluteSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0.");
        }
        this.size = new Dimension(width, height);
    }

    @Override
    public Dimension calculate(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0.");
        }
        return new Dimension(this.size);
    }

    public String toString() {
        return "AbsoluteSize [width=" + this.size.width + ", height=" + this.size.height + "]";
    }
}

