/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.makers.ThumbnailMaker;

public final class ScaledThumbnailMaker
extends ThumbnailMaker {
    private static final String PARAM_SCALE = "scale";
    private double widthFactor;
    private double heightFactor;

    public ScaledThumbnailMaker() {
        this.ready.unset(PARAM_SCALE);
    }

    public ScaledThumbnailMaker(double factor) {
        this();
        this.scale(factor);
    }

    public ScaledThumbnailMaker(double widthFactor, double heightFactor) {
        this();
        this.scale(widthFactor, heightFactor);
    }

    public ScaledThumbnailMaker scale(double factor) {
        return this.scale(factor, factor);
    }

    public ScaledThumbnailMaker scale(double widthFactor, double heightFactor) {
        if (this.ready.isSet(PARAM_SCALE)) {
            throw new IllegalStateException("The scaling factor has already been set.");
        }
        if (widthFactor <= 0.0 || heightFactor <= 0.0) {
            throw new IllegalArgumentException("The scaling factor must be greater than zero.");
        }
        this.widthFactor = widthFactor;
        this.heightFactor = heightFactor;
        this.ready.set(PARAM_SCALE);
        return this;
    }

    @Override
    public BufferedImage make(BufferedImage img) {
        int width = (int)Math.round((double)img.getWidth() * this.widthFactor);
        int height = (int)Math.round((double)img.getHeight() * this.heightFactor);
        width = width == 0 ? 1 : width;
        height = height == 0 ? 1 : height;
        return super.makeThumbnail(img, width, height);
    }
}

