/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.name;

import net.coobird.thumbnailator.ThumbnailParameter;

public abstract class Rename {
    public static final Rename NO_CHANGE = new Rename(){

        @Override
        public String apply(String name, ThumbnailParameter param) {
            return name;
        }
    };
    public static final Rename PREFIX_DOT_THUMBNAIL = new Rename(){

        @Override
        public String apply(String fileName, ThumbnailParameter param) {
            return this.appendPrefix(fileName, "thumbnail.");
        }
    };
    @Deprecated
    public static final Rename PREFIX_HYPTHEN_THUMBNAIL = PREFIX_HYPHEN_THUMBNAIL;
    public static final Rename PREFIX_HYPHEN_THUMBNAIL = new Rename(){

        @Override
        public String apply(String fileName, ThumbnailParameter param) {
            return this.appendPrefix(fileName, "thumbnail-");
        }
    };
    public static final Rename SUFFIX_DOT_THUMBNAIL = new Rename(){

        @Override
        public String apply(String fileName, ThumbnailParameter param) {
            return this.appendSuffix(fileName, ".thumbnail");
        }
    };
    @Deprecated
    public static final Rename SUFFIX_HYPTHEN_THUMBNAIL = SUFFIX_HYPHEN_THUMBNAIL;
    public static final Rename SUFFIX_HYPHEN_THUMBNAIL = new Rename(){

        @Override
        public String apply(String fileName, ThumbnailParameter param) {
            return this.appendSuffix(fileName, "-thumbnail");
        }
    };

    protected Rename() {
    }

    public abstract String apply(String var1, ThumbnailParameter var2);

    protected String appendSuffix(String fileName, String suffix) {
        String newFileName = "";
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            newFileName = fileName.substring(0, indexOfDot);
            newFileName = String.valueOf(newFileName) + suffix;
            newFileName = String.valueOf(newFileName) + fileName.substring(indexOfDot);
        } else {
            newFileName = String.valueOf(fileName) + suffix;
        }
        return newFileName;
    }

    protected String appendPrefix(String fileName, String prefix) {
        return String.valueOf(prefix) + fileName;
    }
}

