/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.resizers;

import java.awt.Dimension;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;
import net.coobird.thumbnailator.resizers.Resizers;

public class DefaultResizerFactory
implements ResizerFactory {
    private static final DefaultResizerFactory INSTANCE = new DefaultResizerFactory();

    private DefaultResizerFactory() {
    }

    public static ResizerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Resizer getResizer() {
        return Resizers.PROGRESSIVE;
    }

    @Override
    public Resizer getResizer(Dimension originalSize, Dimension thumbnailSize) {
        int origWidth = originalSize.width;
        int origHeight = originalSize.height;
        int thumbWidth = thumbnailSize.width;
        int thumbHeight = thumbnailSize.height;
        if (thumbWidth < origWidth && thumbHeight < origHeight) {
            if (thumbWidth < origWidth / 2 && thumbHeight < origHeight / 2) {
                return Resizers.PROGRESSIVE;
            }
            return Resizers.BILINEAR;
        }
        if (thumbWidth > origWidth && thumbHeight > origHeight) {
            return Resizers.BICUBIC;
        }
        if (thumbWidth == origWidth && thumbHeight == origHeight) {
            return Resizers.NULL;
        }
        return this.getResizer();
    }
}

