/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.ThumbnailTask;
import net.coobird.thumbnailator.tasks.io.ImageSink;
import net.coobird.thumbnailator.tasks.io.ImageSource;

public class SourceSinkThumbnailTask<S, D>
extends ThumbnailTask<S, D> {
    private final ImageSource<S> source;
    private final ImageSink<D> destination;

    public SourceSinkThumbnailTask(ThumbnailParameter param, ImageSource<S> source, ImageSink<D> destination) {
        super(param);
        if (source == null) {
            throw new NullPointerException("ImageSource cannot be null.");
        }
        if (destination == null) {
            throw new NullPointerException("ImageSink cannot be null.");
        }
        source.setThumbnailParameter(param);
        this.source = source;
        destination.setThumbnailParameter(param);
        this.destination = destination;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage img = this.source.read();
        this.inputFormatName = this.source.getInputFormatName();
        return img;
    }

    @Override
    public void write(BufferedImage img) throws IOException {
        String paramOutputFormat = this.param.getOutputFormat();
        String formatName = null;
        if ("\u0000".equals(paramOutputFormat)) {
            paramOutputFormat = this.destination.preferredOutputFormatName();
        }
        formatName = paramOutputFormat == ThumbnailParameter.ORIGINAL_FORMAT ? this.inputFormatName : paramOutputFormat;
        this.destination.setOutputFormatName(formatName);
        this.destination.write(img);
    }

    @Override
    public S getSource() {
        return this.source.getSource();
    }

    @Override
    public D getDestination() {
        return this.destination.getSink();
    }
}

