/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;

public class URLImageSource
extends AbstractImageSource<URL> {
    private final URL url;
    private final Proxy proxy;

    public URLImageSource(URL url) {
        if (url == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        this.url = url;
        this.proxy = null;
    }

    public URLImageSource(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        this.url = new URL(url);
        this.proxy = null;
    }

    public URLImageSource(URL url, Proxy proxy) {
        if (url == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null.");
        }
        this.url = url;
        this.proxy = proxy;
    }

    public URLImageSource(String url, Proxy proxy) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null.");
        }
        this.url = new URL(url);
        this.proxy = proxy;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage img;
        InputStreamImageSource source;
        try {
            source = this.proxy != null ? new InputStreamImageSource(this.url.openConnection(this.proxy).getInputStream()) : new InputStreamImageSource(this.url.openStream());
        }
        catch (IOException e) {
            throw new IOException("Could not open connection to URL: " + this.url);
        }
        source.setThumbnailParameter(this.param);
        try {
            img = source.read();
        }
        catch (Exception e) {
            throw new IOException("Could not obtain image from URL: " + this.url);
        }
        this.inputFormatName = source.getInputFormatName();
        return this.finishedReading(img);
    }

    @Override
    public URL getSource() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

