/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;

public final class ThumbnailatorUtils {
    private ThumbnailatorUtils() {
    }

    public static List<String> getSupportedOutputFormats() {
        String[] formats = ImageIO.getWriterFormatNames();
        if (formats == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(formats);
    }

    public static boolean isSupportedOutputFormat(String format) {
        if (format == ThumbnailParameter.ORIGINAL_FORMAT) {
            return true;
        }
        for (String supportedFormat : ThumbnailatorUtils.getSupportedOutputFormats()) {
            if (!supportedFormat.equals(format)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSupportedOutputFormatTypes(String format) {
        String[] types;
        if (format == ThumbnailParameter.ORIGINAL_FORMAT) {
            return Collections.emptyList();
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
        if (!writers.hasNext()) {
            return Collections.emptyList();
        }
        try {
            types = writers.next().getDefaultWriteParam().getCompressionTypes();
        }
        catch (UnsupportedOperationException e) {
            return Collections.emptyList();
        }
        if (types == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(types);
    }

    public static boolean isSupportedOutputFormatType(String format, String type) {
        if (!ThumbnailatorUtils.isSupportedOutputFormat(format)) {
            return false;
        }
        if (format == ThumbnailParameter.ORIGINAL_FORMAT && type == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        if (format == ThumbnailParameter.ORIGINAL_FORMAT && type != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return false;
        }
        if (type == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        for (String supportedType : ThumbnailatorUtils.getSupportedOutputFormatTypes(format)) {
            if (!supportedType.equals(type)) continue;
            return true;
        }
        return false;
    }
}

