/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.Buffer;

public class AmqpWireFormat
implements WireFormat {
    public static final long DEFAULT_MAX_FRAME_SIZE = Long.MAX_VALUE;
    public static final int NO_AMQP_MAX_FRAME_SIZE = -1;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    public static final int DEFAULT_PRODUCER_CREDIT = 1000;
    public static final boolean DEFAULT_ALLOW_NON_SASL_CONNECTIONS = true;
    private static final int SASL_PROTOCOL = 3;
    private int version = 1;
    private long maxFrameSize = Long.MAX_VALUE;
    private int maxAmqpFrameSize = -1;
    private int connectAttemptTimeout = 30000;
    private int idelTimeout = 30000;
    private int producerCredit = 1000;
    private String transformer = "jms";
    private boolean allowNonSaslConnections = true;
    private boolean magicRead = false;
    private ResetListener resetListener;

    @Override
    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteSequence();
    }

    @Override
    public Object unmarshal(ByteSequence packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream(stream);
        return this.unmarshal(dis);
    }

    @Override
    public void marshal(Object command, DataOutput dataOut) throws IOException {
        if (command instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)command;
            if (dataOut instanceof OutputStream) {
                WritableByteChannel channel = Channels.newChannel((OutputStream)((Object)dataOut));
                channel.write(buffer);
            } else {
                while (buffer.hasRemaining()) {
                    dataOut.writeByte(buffer.get());
                }
            }
        } else {
            Buffer frame = (Buffer)command;
            frame.writeTo(dataOut);
        }
    }

    @Override
    public Object unmarshal(DataInput dataIn) throws IOException {
        if (!this.magicRead) {
            Buffer magic = new Buffer(8);
            magic.readFrom(dataIn);
            this.magicRead = true;
            return new AmqpHeader(magic, false);
        }
        int size2 = dataIn.readInt();
        if ((long)size2 > this.maxFrameSize) {
            throw new AmqpProtocolException("Frame size exceeded max frame length.");
        }
        if (size2 <= 0) {
            throw new AmqpProtocolException("Frame size value was invalid: " + size2);
        }
        Buffer frame = new Buffer(size2);
        frame.bigEndianEditor().writeInt(size2);
        frame.readFrom(dataIn);
        frame.clear();
        return frame;
    }

    public boolean isHeaderValid(AmqpHeader header, boolean authenticated) {
        if (!header.hasValidPrefix()) {
            return false;
        }
        if (header.getProtocolId() != 0 && header.getProtocolId() != 3) {
            return false;
        }
        if (!authenticated && !this.isAllowNonSaslConnections() && header.getProtocolId() != 3) {
            return false;
        }
        return header.getMajor() == 1 && header.getMinor() == 0 && header.getRevision() == 0;
    }

    public AmqpHeader getMinimallySupportedHeader() {
        AmqpHeader header = new AmqpHeader();
        if (!this.isAllowNonSaslConnections()) {
            header.setProtocolId(3);
        }
        return header;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void resetMagicRead() {
        this.magicRead = false;
        if (this.resetListener != null) {
            this.resetListener.onProtocolReset();
        }
    }

    public void setProtocolResetListener(ResetListener listener) {
        this.resetListener = listener;
    }

    public boolean isMagicRead() {
        return this.magicRead;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public int getMaxAmqpFrameSize() {
        return this.maxAmqpFrameSize;
    }

    public void setMaxAmqpFrameSize(int maxAmqpFrameSize) {
        this.maxAmqpFrameSize = maxAmqpFrameSize;
    }

    public boolean isAllowNonSaslConnections() {
        return this.allowNonSaslConnections;
    }

    public void setAllowNonSaslConnections(boolean allowNonSaslConnections) {
        this.allowNonSaslConnections = allowNonSaslConnections;
    }

    public int getConnectAttemptTimeout() {
        return this.connectAttemptTimeout;
    }

    public void setConnectAttemptTimeout(int connectAttemptTimeout) {
        this.connectAttemptTimeout = connectAttemptTimeout;
    }

    public void setProducerCredit(int producerCredit) {
        this.producerCredit = producerCredit;
    }

    public int getProducerCredit() {
        return this.producerCredit;
    }

    public String getTransformer() {
        return this.transformer;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    public int getIdleTimeout() {
        return this.idelTimeout;
    }

    public void setIdleTimeout(int idelTimeout) {
        this.idelTimeout = idelTimeout;
    }

    public static interface ResetListener {
        public void onProtocolReset();
    }
}

