/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty9;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.transport.ws.AbstractMQTTSocket;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSocket
extends AbstractMQTTSocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTSocket.class);
    private final int ORDERLY_CLOSE_TIMEOUT = 10;
    private Session session;
    final AtomicBoolean receivedDisconnect = new AtomicBoolean();

    public MQTTSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        ByteSequence bytes = this.wireFormat.marshal(command);
        this.session.getRemote().sendBytes(ByteBuffer.wrap(bytes.getData(), 0, bytes.getLength()));
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketBinary(byte[] bytes, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for MQTTSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for MQTTSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            this.receiveCounter += length;
            MQTTFrame frame = (MQTTFrame)this.wireFormat.unmarshal(new ByteSequence(bytes, offset, length));
            if (frame.messageType() == 14) {
                this.receivedDisconnect.set(true);
            }
            this.getProtocolConverter().onMQTTCommand(frame);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int arg0, String arg1) {
        try {
            if (this.protocolLock.tryLock() || this.protocolLock.tryLock(10L, TimeUnit.SECONDS)) {
                LOG.debug("MQTT WebSocket closed: code[{}] message[{}]", (Object)arg0, (Object)arg1);
                if (!this.receivedDisconnect.get()) {
                    this.getProtocolConverter().onTransportError();
                }
                this.getProtocolConverter().onMQTTCommand(new DISCONNECT().encode());
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", e);
        }
        finally {
            if (this.protocolLock.isHeldByCurrentThread()) {
                this.protocolLock.unlock();
            }
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketError(Throwable arg0) {
    }

    public void onWebSocketText(String arg0) {
    }
}

