/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTraceEventHandler
implements TraceEventHandler,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTraceEventHandler.class);
    private Producer traceEventProducer;
    private Class<?> jpaTraceEventMessageClass;
    private String jpaTraceEventMessageClassName;
    private final Tracer tracer;

    public DefaultTraceEventHandler(Tracer tracer) {
        this.tracer = tracer;
    }

    private synchronized void loadJpaTraceEventMessageClass(Exchange exchange) {
        if (this.jpaTraceEventMessageClass == null) {
            this.jpaTraceEventMessageClassName = this.tracer.getJpaTraceEventMessageClassName();
        }
        if (this.jpaTraceEventMessageClass == null) {
            this.jpaTraceEventMessageClass = exchange.getContext().getClassResolver().resolveClass(this.jpaTraceEventMessageClassName);
            if (this.jpaTraceEventMessageClass == null) {
                throw new IllegalArgumentException("Cannot find class: " + this.jpaTraceEventMessageClassName + ". Make sure camel-jpa.jar is in the classpath.");
            }
        }
    }

    private synchronized Producer getTraceEventProducer(Exchange exchange) throws Exception {
        if (this.traceEventProducer == null) {
            Endpoint endpoint = this.tracer.getDestination() != null ? this.tracer.getDestination() : exchange.getContext().getEndpoint(this.tracer.getDestinationUri());
            this.traceEventProducer = endpoint.createProducer();
            ServiceHelper.startService(this.traceEventProducer);
        }
        return this.traceEventProducer;
    }

    @Override
    public void traceExchange(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        if (this.tracer.getDestination() != null || this.tracer.getDestinationUri() != null) {
            Date timestamp = new Date();
            DefaultExchange event = new DefaultExchange(exchange);
            event.setProperty("CamelTraceEventNodeId", node.getId());
            event.setProperty("CamelTraceEventTimestamp", timestamp);
            event.setProperty("CamelTraceEventExchange", exchange);
            DefaultTraceEventMessage msg = new DefaultTraceEventMessage(timestamp, node, exchange);
            if (this.tracer.isUseJpa()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Using class: " + this.jpaTraceEventMessageClassName + " for tracing event messages");
                }
                this.loadJpaTraceEventMessageClass(exchange);
                Object jpa = ObjectHelper.newInstance(this.jpaTraceEventMessageClass);
                HashMap<String, Object> options = new HashMap<String, Object>();
                IntrospectionSupport.getProperties(msg, options, null);
                IntrospectionSupport.setProperties(exchange.getContext().getTypeConverter(), jpa, options);
                IntrospectionSupport.setProperty(exchange.getContext().getTypeConverter(), jpa, "timestamp", msg.getTimestamp());
                event.getIn().setBody(jpa);
            } else {
                event.getIn().setBody(msg);
            }
            event.setProperty("CamelTraceEvent", Boolean.TRUE);
            try {
                this.getTraceEventProducer(exchange).process(event);
            }
            catch (Exception e) {
                LOG.error("Error processing trace event (original Exchange will continue): " + event, e);
            }
        }
    }

    @Override
    public Object traceExchangeIn(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        this.traceExchange(node, target, traceInterceptor, exchange);
        return null;
    }

    @Override
    public void traceExchangeOut(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange, Object traceState) throws Exception {
        this.traceExchange(node, target, traceInterceptor, exchange);
    }

    @Override
    public void start() throws Exception {
        this.traceEventProducer = null;
    }

    @Override
    public void stop() throws Exception {
        if (this.traceEventProducer != null) {
            ServiceHelper.stopService(this.traceEventProducer);
        }
    }
}

