/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.MetadataService;

public class BaseWritableMetadataService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    static ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    static final ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    static final ConcurrentNavigableMap<String, String> serviceDefinitions = new ConcurrentSkipListMap<String, String>();

    boolean throwableAction(Consumer<URL> consumer, URL url) {
        try {
            consumer.accept(url);
        }
        catch (Exception e) {
            this.logger.error("Failed to remove url metadata to remote center, url is: " + url);
            return false;
        }
        return true;
    }

    public SortedSet<String> getSubscribedURLs() {
        return BaseWritableMetadataService.getAllUnmodifiableServiceURLs(subscribedServiceURLs);
    }

    static SortedSet<String> getAllUnmodifiableServiceURLs(Map<String, SortedSet<URL>> serviceURLs) {
        return MetadataService.toSortedStrings(serviceURLs.values().stream().flatMap(Collection::stream));
    }
}

