/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public enum JobStatus {
    CREATED(TerminalState.NON_TERMINAL),
    RUNNING(TerminalState.NON_TERMINAL),
    FAILING(TerminalState.NON_TERMINAL),
    FAILED(TerminalState.GLOBALLY),
    CANCELLING(TerminalState.NON_TERMINAL),
    CANCELED(TerminalState.GLOBALLY),
    FINISHED(TerminalState.GLOBALLY),
    RESTARTING(TerminalState.NON_TERMINAL),
    SUSPENDED(TerminalState.LOCALLY),
    RECONCILING(TerminalState.NON_TERMINAL);

    private final TerminalState terminalState;

    private JobStatus(TerminalState terminalState) {
        this.terminalState = terminalState;
    }

    public boolean isGloballyTerminalState() {
        return this.terminalState == TerminalState.GLOBALLY;
    }

    public boolean isTerminalState() {
        return this.terminalState != TerminalState.NON_TERMINAL;
    }

    private static enum TerminalState {
        NON_TERMINAL,
        LOCALLY,
        GLOBALLY;

    }
}

