/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class Row
implements Serializable {
    private static final long serialVersionUID = 2L;
    private RowKind kind;
    private final Object[] fields;

    public Row(RowKind kind, int arity) {
        this.kind = Preconditions.checkNotNull(kind, "Row kind must not be null.");
        this.fields = new Object[arity];
    }

    public Row(int arity) {
        this(RowKind.INSERT, arity);
    }

    public RowKind getKind() {
        return this.kind;
    }

    public void setKind(RowKind kind) {
        Preconditions.checkNotNull(kind, "Row kind must not be null.");
        this.kind = kind;
    }

    public int getArity() {
        return this.fields.length;
    }

    @Nullable
    public Object getField(int pos) {
        return this.fields[pos];
    }

    public void setField(int pos, @Nullable Object value) {
        this.fields[pos] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString(this.fields[i]));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return this.kind == row.kind && Arrays.deepEquals(this.fields, row.fields);
    }

    public int hashCode() {
        int result = this.kind.toByteValue();
        result = 31 * result + Arrays.deepHashCode(this.fields);
        return result;
    }

    public static Row of(Object ... values) {
        Row row = new Row(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static Row ofKind(RowKind kind, Object ... values) {
        Row row = new Row(kind, values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static Row copy(Row row) {
        Row newRow = new Row(row.kind, row.fields.length);
        System.arraycopy(row.fields, 0, newRow.fields, 0, row.fields.length);
        return newRow;
    }

    public static Row project(Row row, int[] fields) {
        Row newRow = new Row(row.kind, fields.length);
        for (int i = 0; i < fields.length; ++i) {
            newRow.fields[i] = row.fields[fields[i]];
        }
        return newRow;
    }

    public static Row join(Row first, Row ... remainings) {
        int newLength = first.fields.length;
        for (Row remaining : remainings) {
            newLength += remaining.fields.length;
        }
        Row joinedRow = new Row(first.kind, newLength);
        int index = 0;
        System.arraycopy(first.fields, 0, joinedRow.fields, index, first.fields.length);
        index += first.fields.length;
        for (Row remaining : remainings) {
            System.arraycopy(remaining.fields, 0, joinedRow.fields, index, remaining.fields.length);
            index += remaining.fields.length;
        }
        return joinedRow;
    }
}

