/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import javax.annotation.Nullable;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.ExceptionUtils;

public class TaskManagerExceptionUtils {
    private static final String TM_DIRECT_OOM_ERROR_MESSAGE = String.format("Direct buffer memory. The direct out-of-memory error has occurred. This can mean two things: either job(s) require(s) a larger size of JVM direct memory or there is a direct memory leak. The direct memory can be allocated by user code or some of its dependencies. In this case '%s' configuration option should be increased. Flink framework and its dependencies also consume the direct memory, mostly for network communication. The most of network memory is managed by Flink and should not result in out-of-memory error. In certain special cases, in particular for jobs with high parallelism, the framework may require more direct memory which is not managed by Flink. In this case '%s' configuration option should be increased. If the error persists then there is probably a direct memory leak in user code or some of its dependencies which has to be investigated and fixed. The task executor has to be shutdown...", TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key(), TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key());
    private static final String TM_METASPACE_OOM_ERROR_MESSAGE = String.format("Metaspace. The metaspace out-of-memory error has occurred. This can mean two things: either the job requires a larger size of JVM metaspace to load classes or there is a class loading leak. In the first case '%s' configuration option should be increased. If the error persists (usually in cluster after several job (re-)submissions) then there is probably a class loading leak in user code or some of its dependencies which has to be investigated and fixed. The task executor has to be shutdown...", TaskManagerOptions.JVM_METASPACE.key());

    private TaskManagerExceptionUtils() {
    }

    @Nullable
    public static Throwable tryEnrichTaskManagerError(@Nullable Throwable exception) {
        return ExceptionUtils.tryEnrichOutOfMemoryError(exception, TM_METASPACE_OOM_ERROR_MESSAGE, TM_DIRECT_OOM_ERROR_MESSAGE);
    }
}

