/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    private static final long serialVersionUID = 5010126558083292915L;
    private final CheckpointType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private final boolean isExactlyOnceMode;
    private final boolean isUnalignedCheckpoint;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    @VisibleForTesting
    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this(checkpointType, targetLocation, true, false);
    }

    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation, boolean isExactlyOnceMode, boolean isUnalignedCheckpoint) {
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)targetLocation);
        this.isExactlyOnceMode = isExactlyOnceMode;
        this.isUnalignedCheckpoint = isUnalignedCheckpoint;
    }

    public boolean needsAlignment() {
        return this.isExactlyOnceMode() && (this.getCheckpointType().isSavepoint() || !this.isUnalignedCheckpoint());
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isExactlyOnceMode() {
        return this.isExactlyOnceMode;
    }

    public boolean isUnalignedCheckpoint() {
        return this.isUnalignedCheckpoint;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.targetLocation.hashCode();
        result = 31 * result + this.checkpointType.hashCode();
        result = 31 * result + (this.isExactlyOnceMode ? 1 : 0);
        result = 31 * result + (this.isUnalignedCheckpoint ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType == that.checkpointType && this.targetLocation.equals(that.targetLocation) && this.isExactlyOnceMode == that.isExactlyOnceMode && this.isUnalignedCheckpoint == that.isUnalignedCheckpoint;
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions {checkpointType = " + (Object)((Object)this.checkpointType) + ", targetLocation = " + this.targetLocation + ", isExactlyOnceMode = " + this.isExactlyOnceMode + ", isUnalignedCheckpoint = " + this.isUnalignedCheckpoint + "}";
    }

    @VisibleForTesting
    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }

    public static CheckpointOptions forCheckpointWithDefaultLocation(boolean isExactlyOnceMode, boolean isUnalignedCheckpoint) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault(), isExactlyOnceMode, isUnalignedCheckpoint);
    }
}

