/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.util.Preconditions;

public abstract class SlotProviderStrategy {
    protected final SlotProvider slotProvider;

    SlotProviderStrategy(SlotProvider slotProvider) {
        this.slotProvider = (SlotProvider)Preconditions.checkNotNull((Object)slotProvider);
    }

    public abstract CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId var1, ScheduledUnit var2, SlotProfile var3);

    public void cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        this.slotProvider.cancelSlotRequest(slotRequestId, slotSharingGroupId, cause);
    }

    public static SlotProviderStrategy from(ScheduleMode scheduleMode, SlotProvider slotProvider, Time allocationTimeout) {
        switch (scheduleMode) {
            case LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST: {
                return new BatchSlotProviderStrategy(slotProvider);
            }
            case LAZY_FROM_SOURCES: 
            case EAGER: {
                return new NormalSlotProviderStrategy(slotProvider, allocationTimeout);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown scheduling mode: %s", new Object[]{scheduleMode}));
    }

    SlotProvider asSlotProvider() {
        return this.slotProvider;
    }

    static class NormalSlotProviderStrategy
    extends SlotProviderStrategy {
        private final Time allocationTimeout;

        NormalSlotProviderStrategy(SlotProvider slotProvider, Time allocationTimeout) {
            super(slotProvider);
            this.allocationTimeout = (Time)Preconditions.checkNotNull((Object)allocationTimeout);
        }

        @Override
        public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit scheduledUnit, SlotProfile slotProfile) {
            return this.slotProvider.allocateSlot(slotRequestId, scheduledUnit, slotProfile, this.allocationTimeout);
        }
    }

    static class BatchSlotProviderStrategy
    extends SlotProviderStrategy {
        BatchSlotProviderStrategy(SlotProvider slotProvider) {
            super(slotProvider);
        }

        @Override
        public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit scheduledUnit, SlotProfile slotProfile) {
            return this.slotProvider.allocateBatchSlot(slotRequestId, scheduledUnit, slotProfile);
        }
    }
}

