/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendBuilder;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateBackend;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorage;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class FsStateBackend
extends AbstractFileStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = -8191916350224044011L;
    private static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final int fileStateThreshold;
    private final TernaryBoolean asynchronousSnapshots;
    private final int writeBufferSize;

    public FsStateBackend(String checkpointDataUri) {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(String checkpointDataUri, boolean asynchronousSnapshots) {
        this(new Path(checkpointDataUri), asynchronousSnapshots);
    }

    public FsStateBackend(Path checkpointDataUri) {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(Path checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri.toUri(), asynchronousSnapshots);
    }

    public FsStateBackend(URI checkpointDataUri) {
        this(checkpointDataUri, null, -1, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, @Nullable URI defaultSavepointDirectory) {
        this(checkpointDataUri, defaultSavepointDirectory, -1, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, -1, -1, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold) {
        this(checkpointDataUri, null, fileStateSizeThreshold, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, fileStateSizeThreshold, -1, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDirectory, @Nullable URI defaultSavepointDirectory, int fileStateSizeThreshold, int writeBufferSize, TernaryBoolean asynchronousSnapshots) {
        super((URI)Preconditions.checkNotNull((Object)checkpointDirectory, (String)"checkpoint directory is null"), defaultSavepointDirectory);
        Preconditions.checkNotNull((Object)asynchronousSnapshots, (String)"asynchronousSnapshots");
        Preconditions.checkArgument((fileStateSizeThreshold >= -1 && fileStateSizeThreshold <= 0x100000 ? 1 : 0) != 0, (String)"The threshold for file state size must be in [-1, %s], where '-1' means to use the value from the deployment's configuration.", (Object[])new Object[]{0x100000});
        Preconditions.checkArgument((writeBufferSize >= -1 ? 1 : 0) != 0, (Object)"The write buffer size must be not less than '-1', where '-1' means to use the value from the deployment's configuration.");
        this.fileStateThreshold = fileStateSizeThreshold;
        this.writeBufferSize = writeBufferSize;
        this.asynchronousSnapshots = asynchronousSnapshots;
    }

    private FsStateBackend(FsStateBackend original, ReadableConfig configuration, ClassLoader classLoader) {
        super(original.getCheckpointPath(), original.getSavepointPath(), configuration);
        this.asynchronousSnapshots = original.asynchronousSnapshots.resolveUndefined(((Boolean)configuration.get(CheckpointingOptions.ASYNC_SNAPSHOTS)).booleanValue());
        if (this.getValidFileStateThreshold(original.fileStateThreshold) >= 0) {
            this.fileStateThreshold = original.fileStateThreshold;
        } else {
            int configuredStateThreshold = this.getValidFileStateThreshold(((MemorySize)configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD)).getBytes());
            if (configuredStateThreshold >= 0) {
                this.fileStateThreshold = configuredStateThreshold;
            } else {
                this.fileStateThreshold = MathUtils.checkedDownCast((long)((MemorySize)CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()).getBytes());
                LoggerFactory.getLogger(AbstractFileStateBackend.class).warn("Ignoring invalid file size threshold value ({}): {} - using default value {} instead.", new Object[]{CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.key(), ((MemorySize)configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD)).getBytes(), CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()});
            }
        }
        int bufferSize = original.writeBufferSize >= 0 ? original.writeBufferSize : (Integer)configuration.get(CheckpointingOptions.FS_WRITE_BUFFER_SIZE);
        this.writeBufferSize = Math.max(bufferSize, this.fileStateThreshold);
    }

    private int getValidFileStateThreshold(long fileStateThreshold) {
        if (fileStateThreshold >= 0L && fileStateThreshold <= 0x100000L) {
            return (int)fileStateThreshold;
        }
        return -1;
    }

    @Deprecated
    public Path getBasePath() {
        return this.getCheckpointPath();
    }

    @Override
    @Nonnull
    public Path getCheckpointPath() {
        return super.getCheckpointPath();
    }

    public int getMinFileSizeThreshold() {
        return this.fileStateThreshold >= 0 ? this.fileStateThreshold : MathUtils.checkedDownCast((long)((MemorySize)CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()).getBytes());
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize >= 0 ? this.writeBufferSize : (Integer)CheckpointingOptions.FS_WRITE_BUFFER_SIZE.defaultValue();
    }

    public boolean isUsingAsynchronousSnapshots() {
        return this.asynchronousSnapshots.getOrDefault(((Boolean)CheckpointingOptions.ASYNC_SNAPSHOTS.defaultValue()).booleanValue());
    }

    @Override
    public FsStateBackend configure(ReadableConfig config, ClassLoader classLoader) {
        return new FsStateBackend(this, config, classLoader);
    }

    @Override
    public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (String)"jobId");
        return new FsCheckpointStorage(this.getCheckpointPath(), this.getSavepointPath(), jobId, this.getMinFileSizeThreshold(), this.getWriteBufferSize());
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws BackendBuildingException {
        TaskStateManager taskStateManager = env.getTaskStateManager();
        LocalRecoveryConfig localRecoveryConfig = taskStateManager.createLocalRecoveryConfig();
        HeapPriorityQueueSetFactory priorityQueueSetFactory = new HeapPriorityQueueSetFactory(keyGroupRange, numberOfKeyGroups, 128);
        return new HeapKeyedStateBackendBuilder<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange, env.getExecutionConfig(), ttlTimeProvider, stateHandles, AbstractStateBackend.getCompressionDecorator(env.getExecutionConfig()), localRecoveryConfig, priorityQueueSetFactory, this.isUsingAsynchronousSnapshots(), cancelStreamRegistry).build();
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws BackendBuildingException {
        return new DefaultOperatorStateBackendBuilder(env.getUserClassLoader(), env.getExecutionConfig(), this.isUsingAsynchronousSnapshots(), stateHandles, cancelStreamRegistry).build();
    }

    public String toString() {
        return "File State Backend (checkpoints: '" + this.getCheckpointPath() + "', savepoints: '" + this.getSavepointPath() + "', asynchronous: " + this.asynchronousSnapshots + ", fileStateThreshold: " + this.fileStateThreshold + ")";
    }
}

