/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory.jobmanager;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.FlinkMemoryUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerFlinkMemoryUtils
implements FlinkMemoryUtils<JobManagerFlinkMemory> {
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerFlinkMemoryUtils.class);

    @Override
    public JobManagerFlinkMemory deriveFromRequiredFineGrainedOptions(Configuration config) {
        MemorySize jvmHeapMemorySize = ProcessMemoryUtils.getMemorySizeFromConfig(config, (ConfigOption<MemorySize>)JobManagerOptions.JVM_HEAP_MEMORY);
        MemorySize offHeapMemorySize = ProcessMemoryUtils.getMemorySizeFromConfig(config, (ConfigOption<MemorySize>)JobManagerOptions.OFF_HEAP_MEMORY);
        if (config.contains(JobManagerOptions.TOTAL_FLINK_MEMORY)) {
            MemorySize totalFlinkMemorySize = ProcessMemoryUtils.getMemorySizeFromConfig(config, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_FLINK_MEMORY);
            if (config.contains(JobManagerOptions.OFF_HEAP_MEMORY)) {
                JobManagerFlinkMemoryUtils.sanityCheckTotalFlinkMemory(totalFlinkMemorySize, jvmHeapMemorySize, totalFlinkMemorySize);
            } else {
                offHeapMemorySize = JobManagerFlinkMemoryUtils.deriveOffHeapMemory(jvmHeapMemorySize, totalFlinkMemorySize, offHeapMemorySize);
            }
        }
        return JobManagerFlinkMemoryUtils.createJobManagerFlinkMemory(jvmHeapMemorySize, offHeapMemorySize);
    }

    private static void sanityCheckTotalFlinkMemory(MemorySize totalFlinkMemorySize, MemorySize jvmHeapMemorySize, MemorySize offHeapMemorySize) {
        MemorySize derivedTotalFlinkMemorySize = jvmHeapMemorySize.add(offHeapMemorySize);
        if (derivedTotalFlinkMemorySize.getBytes() != totalFlinkMemorySize.getBytes()) {
            throw new IllegalConfigurationException(String.format("Sum of the configured JVM Heap Memory (%s) and the configured Off-heap Memory (%s) does not match the configured Total Flink Memory (%s). Please, make the configuration consistent or configure only one option: either JVM Heap or Total Flink Memory.", jvmHeapMemorySize.toHumanReadableString(), offHeapMemorySize.toHumanReadableString(), totalFlinkMemorySize.toHumanReadableString()));
        }
    }

    private static MemorySize deriveOffHeapMemory(MemorySize jvmHeapMemorySize, MemorySize totalFlinkMemorySize, MemorySize defaultOffHeapMemorySize) {
        if (totalFlinkMemorySize.getBytes() < jvmHeapMemorySize.getBytes()) {
            throw new IllegalConfigurationException(String.format("The configured JVM Heap Memory (%s) exceeds the configured Total Flink Memory (%s). Please, make the configuration consistent or configure only one option: either JVM Heap or Total Flink Memory.", jvmHeapMemorySize.toHumanReadableString(), totalFlinkMemorySize.toHumanReadableString()));
        }
        MemorySize offHeapMemorySize = totalFlinkMemorySize.subtract(jvmHeapMemorySize);
        if (offHeapMemorySize.getBytes() != defaultOffHeapMemorySize.getBytes()) {
            LOG.info("The Off-Heap Memory size ({}) is derived the configured Total Flink Memory size ({}) minus the configured JVM Heap Memory size ({}). The default Off-Heap Memory size ({}) is ignored.", new Object[]{offHeapMemorySize.toHumanReadableString(), totalFlinkMemorySize.toHumanReadableString(), jvmHeapMemorySize.toHumanReadableString(), defaultOffHeapMemorySize.toHumanReadableString()});
        }
        return offHeapMemorySize;
    }

    @Override
    public JobManagerFlinkMemory deriveFromTotalFlinkMemory(Configuration config, MemorySize totalFlinkMemorySize) {
        MemorySize offHeapMemorySize = ProcessMemoryUtils.getMemorySizeFromConfig(config, (ConfigOption<MemorySize>)JobManagerOptions.OFF_HEAP_MEMORY);
        if (totalFlinkMemorySize.compareTo(offHeapMemorySize) < 1) {
            throw new IllegalConfigurationException("The configured Total Flink Memory (%s) is less than the configured Off-heap Memory (%s).", new Object[]{totalFlinkMemorySize.toHumanReadableString(), offHeapMemorySize.toHumanReadableString()});
        }
        MemorySize derivedJvmHeapMemorySize = totalFlinkMemorySize.subtract(offHeapMemorySize);
        return JobManagerFlinkMemoryUtils.createJobManagerFlinkMemory(derivedJvmHeapMemorySize, offHeapMemorySize);
    }

    private static JobManagerFlinkMemory createJobManagerFlinkMemory(MemorySize jvmHeap, MemorySize offHeapMemory) {
        JobManagerFlinkMemoryUtils.verifyJvmHeapSize(jvmHeap);
        return new JobManagerFlinkMemory(jvmHeap, offHeapMemory);
    }

    private static void verifyJvmHeapSize(MemorySize jvmHeapSize) {
        if (jvmHeapSize.compareTo(JobManagerOptions.MIN_JVM_HEAP_SIZE) < 0) {
            LOG.warn("The configured or derived JVM heap memory size ({}) is less than its recommended minimum value ({})", (Object)jvmHeapSize.toHumanReadableString(), (Object)JobManagerOptions.MIN_JVM_HEAP_SIZE.toHumanReadableString());
        }
    }
}

