/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroSessionScope
implements Scope {
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Subject subject = ThreadContext.getSubject();
                if (subject == null) {
                    throw new OutOfScopeException("There is no Shiro Session currently in scope.");
                }
                Session session = subject.getSession();
                Object scoped = this.castSessionAttribute(session);
                if (scoped == null) {
                    scoped = unscoped.get();
                }
                return scoped;
            }

            private T castSessionAttribute(Session session) {
                return session.getAttribute((Object)key);
            }

            public String toString() {
                return unscoped.toString();
            }
        };
    }

    public String toString() {
        return "ShiroSessionScope";
    }
}

