/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;

public interface AuthenticationTransaction
extends Serializable {
    public Service getService();

    public Collection<Credential> getCredentials();

    default public Optional<Credential> getPrimaryCredential() {
        return this.getCredentials().stream().findFirst();
    }

    default public boolean hasCredentialOfType(Class<? extends Credential> type) {
        return this.getCredentials().stream().anyMatch(type::isInstance);
    }
}

