/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apereo.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface Service
extends Principal {
    public static final Logger LOGGER = LoggerFactory.getLogger(Service.class);

    default public void setPrincipal(String principal) {
    }

    default public boolean matches(Service service) {
        try {
            String thisUrl = URLDecoder.decode(this.getId(), StandardCharsets.UTF_8.name());
            String serviceUrl = URLDecoder.decode(service.getId(), StandardCharsets.UTF_8.name());
            LOGGER.trace("Decoded urls and comparing [{}] with [{}]", (Object)thisUrl, (Object)serviceUrl);
            return thisUrl.equalsIgnoreCase(serviceUrl);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

