/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.hazelcast;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.hazelcast.discovery.HazelcastDiscoveryProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-hazelcast-core")
public class HazelcastClusterProperties
implements Serializable {
    private static final long serialVersionUID = 1817784607045775145L;
    private String partitionMemberGroupType;
    private String loggingType = "slf4j";
    private int maxNoHeartbeatSeconds = 300;
    @RequiredProperty
    private String instanceName = "localhost";
    private boolean portAutoIncrement = true;
    private String mapMergePolicy = "com.hazelcast.map.merge.PutIfAbsentMapMergePolicy";
    @RequiredProperty
    private int port = 5701;
    private boolean multicastEnabled;
    private boolean tcpipEnabled = true;
    @RequiredProperty
    private List<String> members = Stream.of("localhost").collect(Collectors.toList());
    private int maxHeapSizePercentage = 85;
    private String maxSizePolicy = "USED_HEAP_PERCENTAGE";
    private String evictionPolicy = "LRU";
    private int backupCount = 1;
    private int asyncBackupCount;
    private int timeout = 5;
    private boolean ipv4Enabled = true;
    private String multicastTrustedInterfaces;
    private String multicastGroup;
    private int multicastPort;
    private int multicastTimeout = 2;
    private int multicastTimeToLive = 32;
    @NestedConfigurationProperty
    private HazelcastDiscoveryProperties discovery = new HazelcastDiscoveryProperties();

    @Generated
    public String getPartitionMemberGroupType() {
        return this.partitionMemberGroupType;
    }

    @Generated
    public String getLoggingType() {
        return this.loggingType;
    }

    @Generated
    public int getMaxNoHeartbeatSeconds() {
        return this.maxNoHeartbeatSeconds;
    }

    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    @Generated
    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    @Generated
    public String getMapMergePolicy() {
        return this.mapMergePolicy;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    @Generated
    public boolean isTcpipEnabled() {
        return this.tcpipEnabled;
    }

    @Generated
    public List<String> getMembers() {
        return this.members;
    }

    @Generated
    public int getMaxHeapSizePercentage() {
        return this.maxHeapSizePercentage;
    }

    @Generated
    public String getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    @Generated
    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Generated
    public int getBackupCount() {
        return this.backupCount;
    }

    @Generated
    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isIpv4Enabled() {
        return this.ipv4Enabled;
    }

    @Generated
    public String getMulticastTrustedInterfaces() {
        return this.multicastTrustedInterfaces;
    }

    @Generated
    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    @Generated
    public int getMulticastPort() {
        return this.multicastPort;
    }

    @Generated
    public int getMulticastTimeout() {
        return this.multicastTimeout;
    }

    @Generated
    public int getMulticastTimeToLive() {
        return this.multicastTimeToLive;
    }

    @Generated
    public HazelcastDiscoveryProperties getDiscovery() {
        return this.discovery;
    }

    @Generated
    public void setPartitionMemberGroupType(String partitionMemberGroupType) {
        this.partitionMemberGroupType = partitionMemberGroupType;
    }

    @Generated
    public void setLoggingType(String loggingType) {
        this.loggingType = loggingType;
    }

    @Generated
    public void setMaxNoHeartbeatSeconds(int maxNoHeartbeatSeconds) {
        this.maxNoHeartbeatSeconds = maxNoHeartbeatSeconds;
    }

    @Generated
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Generated
    public void setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
    }

    @Generated
    public void setMapMergePolicy(String mapMergePolicy) {
        this.mapMergePolicy = mapMergePolicy;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setMulticastEnabled(boolean multicastEnabled) {
        this.multicastEnabled = multicastEnabled;
    }

    @Generated
    public void setTcpipEnabled(boolean tcpipEnabled) {
        this.tcpipEnabled = tcpipEnabled;
    }

    @Generated
    public void setMembers(List<String> members) {
        this.members = members;
    }

    @Generated
    public void setMaxHeapSizePercentage(int maxHeapSizePercentage) {
        this.maxHeapSizePercentage = maxHeapSizePercentage;
    }

    @Generated
    public void setMaxSizePolicy(String maxSizePolicy) {
        this.maxSizePolicy = maxSizePolicy;
    }

    @Generated
    public void setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
    }

    @Generated
    public void setBackupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    @Generated
    public void setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = asyncBackupCount;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setIpv4Enabled(boolean ipv4Enabled) {
        this.ipv4Enabled = ipv4Enabled;
    }

    @Generated
    public void setMulticastTrustedInterfaces(String multicastTrustedInterfaces) {
        this.multicastTrustedInterfaces = multicastTrustedInterfaces;
    }

    @Generated
    public void setMulticastGroup(String multicastGroup) {
        this.multicastGroup = multicastGroup;
    }

    @Generated
    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    @Generated
    public void setMulticastTimeout(int multicastTimeout) {
        this.multicastTimeout = multicastTimeout;
    }

    @Generated
    public void setMulticastTimeToLive(int multicastTimeToLive) {
        this.multicastTimeToLive = multicastTimeToLive;
    }

    @Generated
    public void setDiscovery(HazelcastDiscoveryProperties discovery) {
        this.discovery = discovery;
    }
}

