/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByCredentialTypeAuthenticationHandlerResolver
implements AuthenticationHandlerResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ByCredentialTypeAuthenticationHandlerResolver.class);
    private final Collection<Class<? extends Credential>> credentials;

    public ByCredentialTypeAuthenticationHandlerResolver(Class<? extends Credential> ... credentials) {
        this(CollectionUtils.wrapSet((Object[])credentials));
    }

    public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) {
        Set<Credential> supportedCreds = this.supported(transaction.getCredentials());
        return candidateHandlers.stream().filter(h -> supportedCreds.stream().anyMatch(arg_0 -> ((AuthenticationHandler)h).supports(arg_0))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean supports(Set<AuthenticationHandler> handlers, AuthenticationTransaction transaction) {
        return this.credentials.stream().anyMatch(arg_0 -> ((AuthenticationTransaction)transaction).hasCredentialOfType(arg_0));
    }

    private Set<Credential> supported(Collection<? extends Credential> candidateCredentials) {
        return candidateCredentials.stream().filter(c -> this.credentials.contains(c.getClass())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Generated
    public ByCredentialTypeAuthenticationHandlerResolver(Collection<Class<? extends Credential>> credentials) {
        this.credentials = credentials;
    }
}

