/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class DefaultAuthentication
implements Authentication {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthentication.class);
    private static final long serialVersionUID = 3206127526058061391L;
    private ZonedDateTime authenticationDate;
    private Principal principal;
    private List<CredentialMetaData> credentials;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Map<String, AuthenticationHandlerExecutionResult> successes;
    private Map<String, Throwable> failures = new LinkedHashMap<String, Throwable>();

    public DefaultAuthentication(@NonNull ZonedDateTime date, @NonNull Principal principal, @NonNull Map<String, Object> attributes, @NonNull Map<String, AuthenticationHandlerExecutionResult> successes) {
        if (date == null) {
            throw new NullPointerException("date is marked @NonNull but is null");
        }
        if (principal == null) {
            throw new NullPointerException("principal is marked @NonNull but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked @NonNull but is null");
        }
        if (successes == null) {
            throw new NullPointerException("successes is marked @NonNull but is null");
        }
        this.authenticationDate = date;
        this.principal = principal;
        this.attributes = attributes;
        this.successes = successes;
        this.credentials = null;
        this.failures = new LinkedHashMap<String, Throwable>();
    }

    public DefaultAuthentication(@NonNull ZonedDateTime date, @NonNull List<CredentialMetaData> credentials, @NonNull Principal principal, @NonNull Map<String, Object> attributes, @NonNull Map<String, AuthenticationHandlerExecutionResult> successes, @NonNull Map<String, Throwable> failures) {
        this(date, principal, attributes, successes);
        if (date == null) {
            throw new NullPointerException("date is marked @NonNull but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked @NonNull but is null");
        }
        if (principal == null) {
            throw new NullPointerException("principal is marked @NonNull but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked @NonNull but is null");
        }
        if (successes == null) {
            throw new NullPointerException("successes is marked @NonNull but is null");
        }
        if (failures == null) {
            throw new NullPointerException("failures is marked @NonNull but is null");
        }
        this.credentials = credentials;
        this.failures = failures;
    }

    public void update(Authentication authn) {
        this.attributes.putAll(authn.getAttributes());
        this.authenticationDate = authn.getAuthenticationDate();
    }

    public void updateAll(Authentication authn) {
        this.attributes.clear();
        this.update(authn);
    }

    public void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Generated
    public DefaultAuthentication() {
    }

    @Generated
    public ZonedDateTime getAuthenticationDate() {
        return this.authenticationDate;
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public List<CredentialMetaData> getCredentials() {
        return this.credentials;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, AuthenticationHandlerExecutionResult> getSuccesses() {
        return this.successes;
    }

    @Generated
    public Map<String, Throwable> getFailures() {
        return this.failures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAuthentication)) {
            return false;
        }
        DefaultAuthentication other = (DefaultAuthentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZonedDateTime this$authenticationDate = this.authenticationDate;
        ZonedDateTime other$authenticationDate = other.authenticationDate;
        if (this$authenticationDate == null ? other$authenticationDate != null : !((Object)this$authenticationDate).equals(other$authenticationDate)) {
            return false;
        }
        Principal this$principal = this.principal;
        Principal other$principal = other.principal;
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        List<CredentialMetaData> this$credentials = this.credentials;
        List<CredentialMetaData> other$credentials = other.credentials;
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        Map<String, Object> this$attributes = this.attributes;
        Map<String, Object> other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, AuthenticationHandlerExecutionResult> this$successes = this.successes;
        Map<String, AuthenticationHandlerExecutionResult> other$successes = other.successes;
        if (this$successes == null ? other$successes != null : !((Object)this$successes).equals(other$successes)) {
            return false;
        }
        Map<String, Throwable> this$failures = this.failures;
        Map<String, Throwable> other$failures = other.failures;
        return !(this$failures == null ? other$failures != null : !((Object)this$failures).equals(other$failures));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultAuthentication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $authenticationDate = this.authenticationDate;
        result = result * 59 + ($authenticationDate == null ? 43 : ((Object)$authenticationDate).hashCode());
        Principal $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        List<CredentialMetaData> $credentials = this.credentials;
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        Map<String, Object> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, AuthenticationHandlerExecutionResult> $successes = this.successes;
        result = result * 59 + ($successes == null ? 43 : ((Object)$successes).hashCode());
        Map<String, Throwable> $failures = this.failures;
        result = result * 59 + ($failures == null ? 43 : ((Object)$failures).hashCode());
        return result;
    }
}

