/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.OrderComparator;

public class DefaultMultifactorAuthenticationContextValidator
implements AuthenticationContextValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationContextValidator.class);
    private final String authenticationContextAttribute;
    private final String globalFailureMode;
    private final String mfaTrustedAuthnAttributeName;
    private final ConfigurableApplicationContext applicationContext;

    public Pair<Boolean, Optional<MultifactorAuthenticationProvider>> validate(Authentication authentication, String requestedContext, RegisteredService service) {
        Collection<MultifactorAuthenticationProvider> satisfiedProviders;
        Map attributes = authentication.getAttributes();
        Object ctxAttr = attributes.get(this.authenticationContextAttribute);
        Set contexts = CollectionUtils.toCollection(ctxAttr);
        LOGGER.debug("Attempting to match requested authentication context [{}] against [{}]", (Object)requestedContext, (Object)contexts);
        Map<String, MultifactorAuthenticationProvider> providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null) {
            LOGGER.debug("No multifactor authentication providers are configured");
            return Pair.of((Object)Boolean.FALSE, Optional.empty());
        }
        Collection<MultifactorAuthenticationProvider> flattenedProviders = MultifactorAuthenticationUtils.flattenProviders(providerMap.values());
        LOGGER.debug("Available MFA Providers are [{}]", flattenedProviders);
        Optional<MultifactorAuthenticationProvider> requestedProvider = DefaultMultifactorAuthenticationContextValidator.locateRequestedProvider(flattenedProviders, requestedContext);
        if (!requestedProvider.isPresent()) {
            LOGGER.debug("Requested authentication provider cannot be recognized.");
            return Pair.of((Object)Boolean.FALSE, Optional.empty());
        }
        LOGGER.debug("RequestedContext is [{}] and Available Contexts are [{}]", (Object)requestedContext, (Object)contexts);
        if (contexts.stream().filter(ctx -> ctx.toString().equals(requestedContext)).count() > 0L) {
            LOGGER.debug("Requested authentication context [{}] is satisfied", (Object)requestedContext);
            return Pair.of((Object)Boolean.TRUE, requestedProvider);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mfaTrustedAuthnAttributeName) && attributes.containsKey(this.mfaTrustedAuthnAttributeName)) {
            LOGGER.debug("Requested authentication context [{}] is satisfied since device is already trusted", (Object)requestedContext);
            return Pair.of((Object)Boolean.TRUE, requestedProvider);
        }
        if (attributes.containsKey("bypassMultifactorAuthentication") && attributes.containsKey("bypassedMultifactorAuthenticationProviderId")) {
            boolean isBypass = (Boolean)Boolean.class.cast(CollectionUtils.firstElement(attributes.get("bypassMultifactorAuthentication")).get());
            String bypassedId = CollectionUtils.firstElement(attributes.get("bypassedMultifactorAuthenticationProviderId")).get().toString();
            LOGGER.debug("Found multifactor authentication bypass attributes for provider [{}]", (Object)bypassedId);
            if (isBypass && StringUtils.equals((CharSequence)bypassedId, (CharSequence)requestedContext)) {
                LOGGER.debug("Requested authentication context [{}] is satisfied given mfa was bypassed for the authentication attempt", (Object)requestedContext);
                return Pair.of((Object)Boolean.TRUE, requestedProvider);
            }
            LOGGER.debug("Either multifactor authentication was not bypassed or the requested context [{}] does not match the bypassed provider [{}]", requestedProvider, (Object)bypassedId);
        }
        LOGGER.debug("Found [{}] providers that may satisfy the context", (Object)((satisfiedProviders = this.getSatisfiedAuthenticationProviders(authentication, flattenedProviders)) != null ? satisfiedProviders.size() : 0));
        if (satisfiedProviders != null && !satisfiedProviders.isEmpty()) {
            MultifactorAuthenticationProvider[] providers = satisfiedProviders.toArray(new MultifactorAuthenticationProvider[0]);
            OrderComparator.sortIfNecessary((Object)providers);
            Optional<MultifactorAuthenticationProvider> result = Arrays.stream(providers).filter(provider -> {
                MultifactorAuthenticationProvider p = (MultifactorAuthenticationProvider)requestedProvider.get();
                return provider.equals(p) || provider.getOrder() >= p.getOrder();
            }).findFirst();
            if (result.isPresent()) {
                LOGGER.debug("Current provider [{}] already satisfies the authentication requirements of [{}]; proceed with flow normally.", (Object)result.get(), requestedProvider);
                return Pair.of((Object)Boolean.TRUE, requestedProvider);
            }
        }
        MultifactorAuthenticationProvider provider2 = requestedProvider.get();
        LOGGER.debug("No multifactor providers could be located to satisfy the requested context for [{}]", (Object)provider2);
        return Pair.of((Object)Boolean.FALSE, requestedProvider);
    }

    private Collection<MultifactorAuthenticationProvider> getSatisfiedAuthenticationProviders(Authentication authentication, Collection<MultifactorAuthenticationProvider> providers) {
        Set contexts = CollectionUtils.toCollection(authentication.getAttributes().get(this.authenticationContextAttribute));
        if (contexts == null || contexts.isEmpty()) {
            LOGGER.debug("No authentication context could be determined based on authentication attribute [{}]", (Object)this.authenticationContextAttribute);
            return null;
        }
        return providers.stream().filter(p -> contexts.contains(p.getId())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Optional<MultifactorAuthenticationProvider> locateRequestedProvider(Collection<MultifactorAuthenticationProvider> providersArray, String requestedProvider) {
        return providersArray.stream().filter(provider -> provider.getId().equals(requestedProvider)).findFirst();
    }

    @Generated
    public String getAuthenticationContextAttribute() {
        return this.authenticationContextAttribute;
    }

    @Generated
    public String getGlobalFailureMode() {
        return this.globalFailureMode;
    }

    @Generated
    public String getMfaTrustedAuthnAttributeName() {
        return this.mfaTrustedAuthnAttributeName;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public DefaultMultifactorAuthenticationContextValidator(String authenticationContextAttribute, String globalFailureMode, String mfaTrustedAuthnAttributeName, ConfigurableApplicationContext applicationContext) {
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.globalFailureMode = globalFailureMode;
        this.mfaTrustedAuthnAttributeName = mfaTrustedAuthnAttributeName;
        this.applicationContext = applicationContext;
    }
}

