/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GroovyMultifactorAuthenticationProviderBypass
implements MultifactorAuthenticationProviderBypass {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyMultifactorAuthenticationProviderBypass.class);
    private static final long serialVersionUID = -4909072898415688377L;
    private final transient WatchableGroovyScriptResource watchableScript;

    public GroovyMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties bypass) {
        Resource groovyScript = bypass.getGroovy().getLocation();
        this.watchableScript = new WatchableGroovyScriptResource(groovyScript);
    }

    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        try {
            Principal principal = authentication.getPrincipal();
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via Groovy script [{}]", new Object[]{principal.getId(), registeredService, provider, this.watchableScript.getResource()});
            Object[] args = new Object[]{authentication, principal, registeredService, provider, LOGGER, request};
            return (Boolean)this.watchableScript.execute(args, Boolean.class);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

