/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorProviderProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;

public class MultifactorAuthenticationProviderBean<T extends MultifactorAuthenticationProvider, P extends BaseMultifactorProviderProperties> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationProviderBean.class);
    private final MultifactorAuthenticationProviderFactory<T, P> providerFactory;
    private final DefaultListableBeanFactory beanFactory;
    private final List<P> properties;

    @PostConstruct
    protected void create() {
        this.properties.stream().forEach(p -> {
            String name = this.providerFactory.beanName(p.getId());
            this.beanFactory.destroySingleton(name);
            this.beanFactory.registerSingleton(name, (Object)this.providerFactory.create(p));
        });
    }

    public T getProvider(String id) {
        return (T)((MultifactorAuthenticationProvider)this.beanFactory.getBean(this.providerFactory.beanName(id), MultifactorAuthenticationProvider.class));
    }

    @EventListener
    public void onRefreshScopeRefreshed(RefreshScopeRefreshedEvent event) {
        LOGGER.debug("Refreshing MFA Providers");
    }

    @Generated
    public MultifactorAuthenticationProviderBean(MultifactorAuthenticationProviderFactory<T, P> providerFactory, DefaultListableBeanFactory beanFactory, List<P> properties) {
        this.providerFactory = providerFactory;
        this.beanFactory = beanFactory;
        this.properties = properties;
    }
}

