/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.ChainingMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.GroovyMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.RestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.VariegatedMultifactorAuthenticationProvider;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class MultifactorAuthenticationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationUtils.class);

    public static MultifactorAuthenticationProviderBypass newMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties props) {
        ChainingMultifactorAuthenticationProviderBypass bypass = new ChainingMultifactorAuthenticationProviderBypass();
        bypass.addBypass(new DefaultMultifactorAuthenticationProviderBypass(props));
        switch (props.getType()) {
            case GROOVY: {
                bypass.addBypass(new GroovyMultifactorAuthenticationProviderBypass(props));
                break;
            }
            case REST: {
                bypass.addBypass(new RestMultifactorAuthenticationProviderBypass(props));
                break;
            }
        }
        return bypass;
    }

    public static Map<String, MultifactorAuthenticationProvider> getAvailableMultifactorAuthenticationProviders(ApplicationContext applicationContext) {
        try {
            return applicationContext.getBeansOfType(MultifactorAuthenticationProvider.class, false, true);
        }
        catch (Exception e) {
            LOGGER.debug("No beans of type [{}] are available in the application context. CAS may not be configured to handle multifactor authentication requests in absence of a provider", MultifactorAuthenticationProvider.class);
            return new HashMap<String, MultifactorAuthenticationProvider>(0);
        }
    }

    public static Collection<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvidersByIds(Collection<String> ids, ApplicationContext applicationContext) {
        Map<String, MultifactorAuthenticationProvider> available = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders(applicationContext);
        Collection<MultifactorAuthenticationProvider> values = available.values();
        return values.stream().filter(p -> ids.contains(p.getId())).collect(Collectors.toSet());
    }

    public static Optional<MultifactorAuthenticationProvider> getMultifactorAuthenticationProviderById(String providerId, ApplicationContext context) {
        return MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders(context).values().stream().filter(p -> p.getId().equals(providerId)).findFirst();
    }

    public static Collection<MultifactorAuthenticationProvider> flattenProviders(Collection<? extends MultifactorAuthenticationProvider> providers) {
        HashSet<MultifactorAuthenticationProvider> flattenedProviders = new HashSet<MultifactorAuthenticationProvider>();
        providers.forEach(p -> flattenedProviders.addAll(MultifactorAuthenticationUtils.flattenProvider(p)));
        return flattenedProviders;
    }

    public static Collection<MultifactorAuthenticationProvider> flattenProvider(MultifactorAuthenticationProvider provider) {
        if (provider instanceof VariegatedMultifactorAuthenticationProvider) {
            return ((VariegatedMultifactorAuthenticationProvider)provider).getProviders();
        }
        return CollectionUtils.wrap((Object)provider);
    }

    @Generated
    private MultifactorAuthenticationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

