/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class RestMultifactorAuthenticationProviderBypass
implements MultifactorAuthenticationProviderBypass {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestMultifactorAuthenticationProviderBypass.class);
    private static final long serialVersionUID = -7553888418344342672L;
    private final MultifactorAuthenticationProviderBypassProperties bypassProperties;

    public RestMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties bypassProperties) {
        this.bypassProperties = bypassProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        HttpResponse response = null;
        try {
            Principal principal = authentication.getPrincipal();
            MultifactorAuthenticationProviderBypassProperties.Rest rest = this.bypassProperties.getRest();
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via REST endpoint [{}]", new Object[]{principal.getId(), registeredService, provider, rest.getUrl()});
            Map parameters = CollectionUtils.wrap((String)"principal", (Object)principal.getId(), (String)"provider", (Object)provider.getId());
            if (registeredService != null) {
                parameters.put("service", registeredService.getServiceId());
            }
            boolean bl = (response = HttpUtils.execute((String)rest.getUrl(), (String)rest.getMethod(), (String)rest.getBasicAuthUsername(), (String)rest.getBasicAuthPassword(), (Map)parameters, new HashMap())).getStatusLine().getStatusCode() == HttpStatus.ACCEPTED.value();
            HttpUtils.close((HttpResponse)response);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            HttpUtils.close(response);
        }
    }
}

