/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.services.json.JsonServiceRegistryProperties;
import org.apereo.cas.services.CasServiceRegistryInitializerConfigurationEventListener;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryInitializer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.resource.AbstractResourceBasedServiceRegistry;
import org.apereo.cas.services.util.CasAddonsRegisteredServicesJsonSerializer;
import org.apereo.cas.services.util.DefaultRegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration(value="casServiceRegistryInitializationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnMissingClass(value={"org.apereo.cas.services.JsonServiceRegistry", "org.apereo.cas.services.YamlServiceRegistry"})
@ConditionalOnBean(value={ServicesManager.class})
@ConditionalOnProperty(prefix="cas.serviceRegistry", name={"initFromJson"}, havingValue="true")
public class CasServiceRegistryInitializationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasServiceRegistryInitializationConfiguration.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="serviceRegistry")
    private ObjectProvider<ServiceRegistry> serviceRegistry;

    @RefreshScope
    @Bean
    public ServiceRegistryInitializer serviceRegistryInitializer() {
        ServiceRegistry serviceRegistryInstance = (ServiceRegistry)this.serviceRegistry.getIfAvailable();
        ServiceRegistryInitializer initializer = new ServiceRegistryInitializer(this.embeddedJsonServiceRegistry(), serviceRegistryInstance, (ServicesManager)this.servicesManager.getIfAvailable());
        LOGGER.info("Attempting to initialize the service registry [{}] from service definition resources found at [{}]", (Object)serviceRegistryInstance.getName(), (Object)this.getServiceRegistryInitializerServicesDirectoryResource());
        initializer.initServiceRegistryIfNecessary();
        return initializer;
    }

    @Bean
    @RefreshScope
    public CasServiceRegistryInitializerConfigurationEventListener serviceRegistryInitializerConfigurationEventListener() {
        return new CasServiceRegistryInitializerConfigurationEventListener(this.serviceRegistryInitializer());
    }

    @RefreshScope
    @Bean
    public ServiceRegistry embeddedJsonServiceRegistry() {
        Resource location = this.getServiceRegistryInitializerServicesDirectoryResource();
        return new EmbeddedResourceBasedServiceRegistry(this.eventPublisher, location);
    }

    private Resource getServiceRegistryInitializerServicesDirectoryResource() {
        JsonServiceRegistryProperties registry = this.casProperties.getServiceRegistry().getJson();
        return (Resource)ObjectUtils.defaultIfNull((Object)registry.getLocation(), (Object)new ClassPathResource("services"));
    }

    public static class EmbeddedResourceBasedServiceRegistry
    extends AbstractResourceBasedServiceRegistry {
        EmbeddedResourceBasedServiceRegistry(ApplicationEventPublisher publisher, Resource location) throws Exception {
            super(location, (Collection)EmbeddedResourceBasedServiceRegistry.getRegisteredServiceSerializers(), publisher);
        }

        private static List getRegisteredServiceSerializers() {
            return CollectionUtils.wrapList((Object[])new DefaultRegisteredServiceJsonSerializer[]{new CasAddonsRegisteredServicesJsonSerializer(), new DefaultRegisteredServiceJsonSerializer()});
        }

        protected String getExtension() {
            return "json";
        }
    }
}

