/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.expiration.builder;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.ticket.TicketGrantingTicketProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.AlwaysExpiresExpirationPolicy;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.expiration.RememberMeDelegatingExpirationPolicy;
import org.apereo.cas.ticket.expiration.ThrottledUseAndTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.TicketGrantingTicketExpirationPolicy;
import org.apereo.cas.ticket.expiration.TimeoutExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class TicketGrantingTicketExpirationPolicyBuilder
implements ExpirationPolicyBuilder<TicketGrantingTicket> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketExpirationPolicyBuilder.class);
    private static final long serialVersionUID = -4197980180617072826L;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        if (tgt.getRememberMe().isEnabled()) {
            ExpirationPolicy p = this.toRememberMeTicketExpirationPolicy();
            LOGGER.debug("Final effective time-to-live of remember-me expiration policy is [{}] seconds", (Object)p.getTimeToLive());
            return p;
        }
        ExpirationPolicy p = this.toTicketGrantingTicketExpirationPolicy();
        LOGGER.debug("Final effective time-to-live of ticket-granting ticket expiration policy is [{}] seconds", (Object)p.getTimeToLive());
        return p;
    }

    public Class<TicketGrantingTicket> getTicketType() {
        return TicketGrantingTicket.class;
    }

    public ExpirationPolicy toTicketGrantingTicketExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        if (tgt.getMaxTimeToLiveInSeconds() <= 0 && tgt.getTimeToKillInSeconds() <= 0) {
            LOGGER.warn("Ticket-granting ticket expiration policy is set to NEVER expire tickets.");
            return NeverExpiresExpirationPolicy.INSTANCE;
        }
        if (tgt.getTimeout().getMaxTimeToLiveInSeconds() > 0) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on a timeout of [{}] seconds", (Object)tgt.getTimeout().getMaxTimeToLiveInSeconds());
            return new TimeoutExpirationPolicy(tgt.getTimeout().getMaxTimeToLiveInSeconds());
        }
        if (tgt.getThrottledTimeout().getTimeInBetweenUsesInSeconds() > 0L && tgt.getThrottledTimeout().getTimeToKillInSeconds() > 0L) {
            ThrottledUseAndTimeoutExpirationPolicy p = new ThrottledUseAndTimeoutExpirationPolicy();
            p.setTimeToKillInSeconds(tgt.getThrottledTimeout().getTimeToKillInSeconds());
            p.setTimeInBetweenUsesInSeconds(tgt.getThrottledTimeout().getTimeInBetweenUsesInSeconds());
            LOGGER.debug("Ticket-granting ticket expiration policy is based on throttled timeouts");
            return p;
        }
        if (tgt.getHardTimeout().getTimeToKillInSeconds() > 0L) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on a hard timeout of [{}] seconds", (Object)tgt.getHardTimeout().getTimeToKillInSeconds());
            return new HardTimeoutExpirationPolicy(tgt.getHardTimeout().getTimeToKillInSeconds());
        }
        if (tgt.getMaxTimeToLiveInSeconds() > 0 && tgt.getTimeToKillInSeconds() > 0) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on hard/idle timeouts of [{}]/[{}] seconds", (Object)tgt.getMaxTimeToLiveInSeconds(), (Object)tgt.getTimeToKillInSeconds());
            return new TicketGrantingTicketExpirationPolicy(tgt.getMaxTimeToLiveInSeconds(), tgt.getTimeToKillInSeconds());
        }
        LOGGER.warn("Ticket-granting ticket expiration policy is set to ALWAYS expire tickets.");
        return new AlwaysExpiresExpirationPolicy();
    }

    public ExpirationPolicy toRememberMeTicketExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        LOGGER.debug("Remember me expiration policy is being configured based on hard timeout of [{}] seconds", (Object)tgt.getRememberMe().getTimeToKillInSeconds());
        HardTimeoutExpirationPolicy rememberMePolicy = new HardTimeoutExpirationPolicy(tgt.getRememberMe().getTimeToKillInSeconds());
        RememberMeDelegatingExpirationPolicy p = new RememberMeDelegatingExpirationPolicy();
        p.addPolicy("REMEMBER_ME", (ExpirationPolicy)rememberMePolicy);
        p.addPolicy("DEFAULT", this.toTicketGrantingTicketExpirationPolicy());
        return p;
    }

    @Generated
    public TicketGrantingTicketExpirationPolicyBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "TicketGrantingTicketExpirationPolicyBuilder(casProperties=" + this.casProperties + ")";
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

