/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyGrantingTicketFactory
implements ProxyGrantingTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProxyGrantingTicketFactory.class);
    protected final UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    protected final ExpirationPolicyBuilder<ProxyGrantingTicket> ticketGrantingTicketExpirationPolicy;
    protected final CipherExecutor<String, String> cipherExecutor;

    public <T extends ProxyGrantingTicket> T create(ServiceTicket serviceTicket, Authentication authentication, Class<T> clazz) throws AbstractTicketException {
        String pgtId = this.produceTicketIdentifier();
        return this.produceTicket(serviceTicket, authentication, pgtId, clazz);
    }

    protected <T extends ProxyGrantingTicket> T produceTicket(ServiceTicket serviceTicket, Authentication authentication, String pgtId, Class<T> clazz) {
        ProxyGrantingTicket result = serviceTicket.grantProxyGrantingTicket(pgtId, authentication, this.ticketGrantingTicketExpirationPolicy.buildTicketExpirationPolicy());
        if (result == null) {
            throw new IllegalArgumentException("Unable to create the proxy-granting ticket object for identifier " + pgtId);
        }
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
        }
        return (T)result;
    }

    protected String produceTicketIdentifier() {
        String pgtId = this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("PGT");
        if (this.cipherExecutor == null) {
            return pgtId;
        }
        LOGGER.debug("Attempting to encode proxy-granting ticket [{}]", (Object)pgtId);
        String pgtEncoded = (String)this.cipherExecutor.encode((Object)pgtId);
        LOGGER.debug("Encoded proxy-granting ticket id [{}]", (Object)pgtEncoded);
        return pgtEncoded;
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    @Generated
    public DefaultProxyGrantingTicketFactory(UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, ExpirationPolicyBuilder<ProxyGrantingTicket> ticketGrantingTicketExpirationPolicy, CipherExecutor<String, String> cipherExecutor) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        this.cipherExecutor = cipherExecutor;
    }
}

