/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.io.Serializable;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DefaultTicketRegistryCleaner
implements TicketRegistryCleaner,
Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketRegistryCleaner.class);
    private static final long serialVersionUID = -8581398063126547772L;
    private final transient LockingStrategy lockingStrategy;
    private final transient LogoutManager logoutManager;
    private final transient TicketRegistry ticketRegistry;

    public int clean() {
        try {
            if (!this.isCleanerSupported()) {
                LOGGER.trace("Ticket registry cleaner is not supported by [{}]. No cleaner processes will run.", (Object)this.getClass().getSimpleName());
                int n = 0;
                return n;
            }
            LOGGER.trace("Attempting to acquire ticket cleanup lock.");
            if (!this.lockingStrategy.acquire()) {
                LOGGER.info("Could not obtain lock. Aborting cleanup. The ticket registry may not support self-service maintenance.");
                int n = 0;
                return n;
            }
            LOGGER.trace("Acquired lock. Proceeding with cleanup.");
            int n = this.cleanInternal();
            return n;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LOGGER.trace("Releasing ticket cleanup lock.");
            this.lockingStrategy.release();
            LOGGER.debug("Finished ticket cleanup.");
        }
        return 0;
    }

    protected int cleanInternal() {
        try (Stream<Ticket> expiredTickets = this.ticketRegistry.getTicketsStream().filter(Ticket::isExpired);){
            int ticketsDeleted = expiredTickets.mapToInt(this::cleanTicket).sum();
            LOGGER.info("[{}] expired tickets removed.", (Object)ticketsDeleted);
            int n = ticketsDeleted;
            return n;
        }
    }

    public int cleanTicket(Ticket ticket) {
        if (ticket instanceof TicketGrantingTicket) {
            LOGGER.debug("Cleaning up expired ticket-granting ticket [{}]", (Object)ticket.getId());
            this.logoutManager.performLogout((TicketGrantingTicket)ticket);
        }
        LOGGER.debug("Cleaning up expired ticket [{}]", (Object)ticket.getId());
        return this.ticketRegistry.deleteTicket(ticket);
    }

    protected boolean isCleanerSupported() {
        return true;
    }

    @Generated
    public DefaultTicketRegistryCleaner(LockingStrategy lockingStrategy, LogoutManager logoutManager, TicketRegistry ticketRegistry) {
        this.lockingStrategy = lockingStrategy;
        this.logoutManager = logoutManager;
        this.ticketRegistry = ticketRegistry;
    }
}

