/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import javax.validation.MessageInterpolator;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CasEmbeddedValueResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProvidersProperties;
import org.apereo.cas.util.SchedulingUtils;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.util.io.GroovySmsSender;
import org.apereo.cas.util.io.RestfulSmsSender;
import org.apereo.cas.util.io.SmsSender;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.Converters;
import org.apereo.cas.util.spring.SpringAwareMessageMessageInterpolator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.beanvalidation.BeanValidationPostProcessor;

@Configuration(value="casCoreUtilConfiguration")
@AutoConfigureOrder(value=-2147483648)
@EnableScheduling
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreUtilConfiguration
implements InitializingBean {
    @Autowired
    @Qualifier(value="mailSender")
    private ObjectProvider<JavaMailSender> mailSender;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @Scope(value="prototype")
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public MessageInterpolator messageInterpolator() {
        return new SpringAwareMessageMessageInterpolator();
    }

    @Bean
    @ConditionalOnMissingBean(name={"communicationsManager"})
    public CommunicationsManager communicationsManager() {
        return new CommunicationsManager(this.smsSender(), (JavaMailSender)this.mailSender.getIfAvailable());
    }

    @Bean
    @Role(value=2)
    @Order(value=-2147483648)
    public StringValueResolver durationCapableStringValueResolver() {
        return SchedulingUtils.prepScheduledAnnotationBeanPostProcessor((ApplicationContext)this.applicationContext);
    }

    @Bean
    public Converter<ZonedDateTime, String> zonedDateTimeToStringConverter() {
        return new Converters.ZonedDateTimeToStringConverter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"casBeanValidationPostProcessor"})
    public BeanValidationPostProcessor casBeanValidationPostProcessor() {
        return new BeanValidationPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"smsSender"})
    @RefreshScope
    public SmsSender smsSender() {
        SmsProvidersProperties.Groovy groovy = this.casProperties.getSmsProvider().getGroovy();
        if (groovy.getLocation() != null) {
            return new GroovySmsSender(groovy.getLocation());
        }
        SmsProvidersProperties.Rest rest = this.casProperties.getSmsProvider().getRest();
        if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
            return new RestfulSmsSender(rest);
        }
        return SmsSender.noOp();
    }

    @SuppressFBWarnings(value={"NIR_NEEDLESS_INSTANCE_RETRIEVAL"})
    public void afterPropertiesSet() {
        this.applicationContextProvider();
        ConfigurableApplicationContext appContext = ApplicationContextProvider.getConfigurableApplicationContext();
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(true);
        conversionService.setEmbeddedValueResolver((StringValueResolver)new CasEmbeddedValueResolver((ApplicationContext)appContext));
        appContext.getEnvironment().setConversionService((ConfigurableConversionService)conversionService);
        if (appContext.getParent() != null) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)appContext.getParent().getEnvironment();
            env.setConversionService((ConfigurableConversionService)conversionService);
        }
        ConverterRegistry registry = (ConverterRegistry)DefaultConversionService.getSharedInstance();
        registry.addConverter(this.zonedDateTimeToStringConverter());
    }
}

