/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAuthenticationAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationAction.class);
    private final CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    private final CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    private final AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;

    protected Event doExecute(RequestContext requestContext) {
        String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext();
        GeoLocationRequest geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext();
        if (geoLocation != null && StringUtils.isNotBlank((CharSequence)agent) && !this.adaptiveAuthenticationPolicy.apply(agent, geoLocation)) {
            String msg = "Adaptive authentication policy does not allow this request for " + agent + " and " + geoLocation;
            Map map = CollectionUtils.wrap((String)UnauthorizedAuthenticationException.class.getSimpleName(), (Object)new UnauthorizedAuthenticationException(msg));
            AuthenticationException error = new AuthenticationException(msg, map, new HashMap(0));
            return new Event((Object)this, "authenticationFailure", (AttributeMap)new LocalAttributeMap("error", (Object)error));
        }
        Event serviceTicketEvent = this.serviceTicketRequestWebflowEventResolver.resolveSingle(requestContext);
        if (serviceTicketEvent != null) {
            this.fireEventHooks(serviceTicketEvent, requestContext);
            return serviceTicketEvent;
        }
        Event finalEvent = this.initialAuthenticationAttemptWebflowEventResolver.resolveSingle(requestContext);
        this.fireEventHooks(finalEvent, requestContext);
        return finalEvent;
    }

    private void fireEventHooks(Event e, RequestContext ctx) {
        if (e.getId().equals("error")) {
            this.onError(ctx);
        }
        if (e.getId().equals("warn")) {
            this.onWarn(ctx);
        }
        if (e.getId().equals("success")) {
            this.onSuccess(ctx);
        }
    }

    protected void onWarn(RequestContext context) {
    }

    protected void onSuccess(RequestContext context) {
    }

    protected void onError(RequestContext context) {
    }

    @Generated
    public AbstractAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
        this.initialAuthenticationAttemptWebflowEventResolver = initialAuthenticationAttemptWebflowEventResolver;
        this.serviceTicketRequestWebflowEventResolver = serviceTicketRequestWebflowEventResolver;
        this.adaptiveAuthenticationPolicy = adaptiveAuthenticationPolicy;
    }
}

