/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RankedAuthenticationProviderWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RankedAuthenticationProviderWebflowEventResolver.class);
    private final CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    private final AuthenticationContextValidator authenticationContextValidator;

    public RankedAuthenticationProviderWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, AuthenticationContextValidator authenticationContextValidator, CasDelegatingWebflowEventResolver casDelegatingWebflowEventResolver) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.authenticationContextValidator = authenticationContextValidator;
        this.initialAuthenticationAttemptWebflowEventResolver = casDelegatingWebflowEventResolver;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)context);
        if (service == null) {
            LOGGER.debug("No service is available to determine event for principal");
            return this.resumeFlow();
        }
        if (StringUtils.isBlank((CharSequence)tgt)) {
            LOGGER.trace("TGT is blank; proceed with flow normally.");
            return this.resumeFlow();
        }
        Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(tgt);
        if (authentication == null) {
            LOGGER.trace("TGT has no authentication and is blank; proceed with flow normally.");
            return this.resumeFlow();
        }
        Credential credential = WebUtils.getCredential((RequestContext)context);
        AuthenticationResultBuilder builder = this.authenticationSystemSupport.establishAuthenticationContextFromInitial(authentication, credential);
        LOGGER.debug("Recording and tracking initial authentication results in the request context");
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        Event event = this.initialAuthenticationAttemptWebflowEventResolver.resolveSingle(context);
        if (event == null) {
            LOGGER.trace("Request does not indicate a requirement for authentication policy; proceed with flow normally.");
            return this.resumeFlow();
        }
        String id = event.getId();
        LOGGER.debug("Resolved event from the initial authentication leg is [{}]", (Object)id);
        if (id.equals("error") || id.equals("authenticationFailure") || id.equals("success") || id.equals("successWithWarnings")) {
            LOGGER.debug("Returning webflow event as [{}]", (Object)id);
            return CollectionUtils.wrapSet((Object)event);
        }
        LOGGER.debug("Validating authentication context for event [{}] and service [{}]", (Object)id, (Object)service);
        Pair result = this.authenticationContextValidator.validate(authentication, id, service);
        if (((Boolean)result.getKey()).booleanValue()) {
            LOGGER.debug("Authentication context is successfully validated by [{}] for service [{}]", (Object)id, (Object)service);
            return this.resumeFlow();
        }
        Optional value = (Optional)result.getValue();
        if (value.isPresent()) {
            Map<String, Object> attributeMap = RankedAuthenticationProviderWebflowEventResolver.buildEventAttributeMap(authentication.getPrincipal(), service, (MultifactorAuthenticationProvider)value.get());
            return CollectionUtils.wrapSet((Object)this.validateEventIdForMatchingTransitionInContext(id, context, attributeMap));
        }
        LOGGER.warn("The authentication context cannot be satisfied and the requested event [{}] is unrecognized", (Object)id);
        return CollectionUtils.wrapSet((Object)new Event((Object)this, "error"));
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }

    private Set<Event> resumeFlow() {
        return CollectionUtils.wrapSet((Object)new EventFactorySupport().success((Object)this));
    }
}

