/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceTicketRequestWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketRequestWebflowEventResolver.class);
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final CasConfigurationProperties casProperties;

    public ServiceTicketRequestWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, AuditableExecution registeredServiceAccessStrategyEnforcer, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.casProperties = casProperties;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        if (this.isRequestAskingForServiceTicket(context)) {
            LOGGER.debug("Authentication request is asking for service tickets");
            return CollectionUtils.wrapSet((Object)this.grantServiceTicket(context));
        }
        return null;
    }

    protected boolean isRequestAskingForServiceTicket(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        LOGGER.debug("Located ticket-granting ticket [{}] from the request context", (Object)ticketGrantingTicketId);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        LOGGER.debug("Located service [{}] from the request context", (Object)service);
        String renewParam = this.casProperties.getSso().isRenewAuthnEnabled() ? context.getRequestParameters().get("renew") : "";
        LOGGER.debug("Provided value for [{}] request parameter is [{}]", (Object)"renew", (Object)renewParam);
        if (service != null && StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId)) {
            Authentication authn = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicketId);
            if (StringUtils.isNotBlank((CharSequence)renewParam)) {
                boolean validAuthn;
                LOGGER.debug("Request identifies itself as one asking for service tickets. Checking for authentication context validity...");
                boolean bl = validAuthn = authn != null;
                if (validAuthn) {
                    LOGGER.debug("Existing authentication context linked to ticket-granting ticket [{}] is valid. CAS should begin to issue service tickets for [{}] once credentials are renewed", (Object)ticketGrantingTicketId, (Object)service);
                    return true;
                }
                LOGGER.debug("Existing authentication context linked to ticket-granting ticket [{}] is NOT valid. CAS will not issue service tickets for [{}] just yet without renewing the authentication context", (Object)ticketGrantingTicketId, (Object)service);
                return false;
            }
        }
        LOGGER.debug("Request is not eligible to be issued service tickets just yet");
        return false;
    }

    protected Event grantServiceTicket(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        Credential credential = this.getCredentialFromContext(context);
        try {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            Authentication authn = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicketId);
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            if (authn != null && registeredService != null) {
                LOGGER.debug("Enforcing access strategy policies for registered service [{}] and principal [{}]", (Object)registeredService, (Object)authn.getPrincipal());
                AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(authn).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.TRUE).build();
                AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
                accessResult.throwExceptionIfNeeded();
            }
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction((Service)service, new Credential[]{credential});
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, authenticationResult);
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            WebUtils.putWarnCookieIfRequestParameterPresent((CookieGenerator)this.warnCookieGenerator, (RequestContext)context);
            return this.newEvent("warn");
        }
        catch (AuthenticationException | AbstractTicketException e) {
            return this.newEvent("authenticationFailure", (Exception)e);
        }
    }
}

