/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GroovyScriptMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptMultifactorAuthenticationPolicyEventResolver.class);
    private final WatchableGroovyScriptResource watchableScript;
    private final CasConfigurationProperties casProperties;

    public GroovyScriptMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.casProperties = casProperties;
        Resource groovyScript = casProperties.getAuthn().getMfa().getGroovyScript();
        this.watchableScript = new WatchableGroovyScriptResource(groovyScript);
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        Service service = this.resolveServiceFromAuthenticationRequest(context);
        RegisteredService registeredService = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        Resource groovyScript = this.casProperties.getAuthn().getMfa().getGroovyScript();
        if (groovyScript == null) {
            LOGGER.debug("No groovy script is configured for multifactor authentication");
            return null;
        }
        if (!ResourceUtils.doesResourceExist((Resource)groovyScript)) {
            LOGGER.warn("No groovy script is found at [{}] for multifactor authentication", (Object)groovyScript);
            return null;
        }
        if (authentication == null) {
            LOGGER.debug("No authentication is available to determine event for principal");
            return null;
        }
        if (registeredService == null || service == null) {
            LOGGER.debug("No registered service is available to determine event for principal [{}]", (Object)authentication.getPrincipal());
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        try {
            Object[] args = new Object[]{service, registeredService, authentication, LOGGER};
            String provider = (String)this.watchableScript.execute(args, String.class);
            LOGGER.debug("Groovy script run for [{}] returned the provider id [{}]", (Object)service, (Object)provider);
            if (StringUtils.isBlank((CharSequence)provider)) {
                return null;
            }
            Optional<MultifactorAuthenticationProvider> providerFound = this.resolveProvider((Map<String, MultifactorAuthenticationProvider>)providerMap, provider);
            if (providerFound.isPresent()) {
                MultifactorAuthenticationProvider multifactorAuthenticationProvider = providerFound.get();
                Event event = this.validateEventIdForMatchingTransitionInContext(multifactorAuthenticationProvider.getId(), context, GroovyScriptMultifactorAuthenticationPolicyEventResolver.buildEventAttributeMap(authentication.getPrincipal(), registeredService, multifactorAuthenticationProvider));
                return CollectionUtils.wrapSet((Object)event);
            }
            LOGGER.warn("No multifactor provider could be found for [{}]", (Object)provider);
            throw new AuthenticationException();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

