/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.web.flow.resolver.impl.mfa.PrincipalAttributeMultifactorAuthenticationPolicyEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PredicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver
extends PrincipalAttributeMultifactorAuthenticationPolicyEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PredicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver.class);
    private static final Class[] PREDICATE_CTOR_PARAMETERS = new Class[]{Object.class, Object.class, Object.class, Object.class};
    private final Resource predicateResource;

    public PredicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authSelectionStrategies, selector, casProperties);
        this.predicateResource = casProperties.getAuthn().getMfa().getGlobalPrincipalAttributePredicate();
    }

    @Override
    protected Set<Event> resolveMultifactorProviderViaPredicate(RequestContext context, RegisteredService service, Principal principal, Collection<MultifactorAuthenticationProvider> providers) {
        if (this.predicateResource == null || !ResourceUtils.doesResourceExist((Resource)this.predicateResource)) {
            LOGGER.debug("No groovy script predicate is defined to decide which multifactor authentication provider should be chosen");
            return null;
        }
        if (providers == null || providers.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            return null;
        }
        Object[] args = new Object[]{service, principal, providers, LOGGER};
        Predicate predicate = (Predicate)ScriptingUtils.getObjectInstanceFromGroovyResource((Resource)this.predicateResource, (Class[])PREDICATE_CTOR_PARAMETERS, (Object[])args, Predicate.class);
        LOGGER.debug("Created predicate instance [{}] from [{}] to filter multifactor authentication providers [{}]", new Object[]{predicate.getClass().getSimpleName(), this.predicateResource, providers});
        MultifactorAuthenticationProvider provider = providers.stream().filter(predicate).sorted(Comparator.comparingInt(Ordered::getOrder)).findFirst().orElse(null);
        LOGGER.debug("Predicate instance [{}] returned multifactor authentication provider [{}]", (Object)predicate.getClass().getSimpleName(), (Object)provider);
        return this.evaluateEventForProviderInContext(principal, service, context, provider);
    }
}

