/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa.request;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.resolver.impl.mfa.request.BaseRequestMultifactorAuthenticationPolicyEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;

public class RequestParameterMultifactorAuthenticationPolicyEventResolver
extends BaseRequestMultifactorAuthenticationPolicyEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParameterMultifactorAuthenticationPolicyEventResolver.class);
    private final String mfaRequestParameter;

    public RequestParameterMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationStrategies, selector, casProperties);
        this.mfaRequestParameter = casProperties.getAuthn().getMfa().getRequestParameter();
    }

    @Override
    protected List<String> resolveEventFromHttpRequest(HttpServletRequest request) {
        String[] values = request.getParameterValues(this.mfaRequestParameter);
        if (values != null && values.length > 0) {
            LOGGER.debug("Received request parameter [{}] as [{}]", (Object)this.mfaRequestParameter, (Object)values);
            return Arrays.stream(values).collect(Collectors.toList());
        }
        LOGGER.debug("No value could be found for request parameter [{}]", (Object)this.mfaRequestParameter);
        return null;
    }
}

