/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa.request;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.impl.mfa.request.BaseRequestMultifactorAuthenticationPolicyEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;

public class RequestSessionAttributeMultifactorAuthenticationPolicyEventResolver
extends BaseRequestMultifactorAuthenticationPolicyEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSessionAttributeMultifactorAuthenticationPolicyEventResolver.class);
    private final String attributeName;

    public RequestSessionAttributeMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationStrategies, selector, casProperties);
        this.attributeName = casProperties.getAuthn().getMfa().getSessionAttribute();
    }

    @Override
    protected List<String> resolveEventFromHttpRequest(HttpServletRequest request) {
        Object attributeValue;
        HttpSession session = request.getSession(false);
        Object object = attributeValue = session != null ? session.getAttribute(this.attributeName) : null;
        if (attributeValue == null) {
            LOGGER.debug("No value could be found for session attribute [{}]. Checking request attributes...", (Object)this.attributeName);
            attributeValue = request.getAttribute(this.attributeName);
        }
        if (attributeValue == null) {
            LOGGER.debug("No value could be found for [{}]", (Object)this.attributeName);
            return null;
        }
        Set values = CollectionUtils.toCollection((Object)attributeValue);
        LOGGER.debug("Found values [{}] mapped to attribute name [{}]", (Object)values, (Object)this.attributeName);
        return values.stream().map(Object::toString).collect(Collectors.toList());
    }
}

