/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class ChainingSingleSignOnParticipationStrategy
implements SingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingSingleSignOnParticipationStrategy.class);
    private final List<SingleSignOnParticipationStrategy> providers = new ArrayList<SingleSignOnParticipationStrategy>();

    public void addStrategy(SingleSignOnParticipationStrategy provider) {
        this.providers.add(provider);
    }

    public void addStrategy(List<SingleSignOnParticipationStrategy> provider) {
        this.providers.addAll(provider);
    }

    public boolean isParticipating(RequestContext context) {
        List<SingleSignOnParticipationStrategy> supporters = this.getSupportingSingleSignOnParticipationStrategies(context);
        if (supporters.isEmpty()) {
            return SingleSignOnParticipationStrategy.alwaysParticipating().isParticipating(context);
        }
        return supporters.stream().allMatch(p -> p.isParticipating(context));
    }

    public boolean isCreateCookieOnRenewedAuthentication(RequestContext context) {
        List<SingleSignOnParticipationStrategy> supporters = this.getSupportingSingleSignOnParticipationStrategies(context);
        return supporters.stream().allMatch(p -> p.isCreateCookieOnRenewedAuthentication(context));
    }

    public boolean supports(RequestContext context) {
        return this.providers.stream().anyMatch(p -> p.supports(context));
    }

    private List<SingleSignOnParticipationStrategy> getSupportingSingleSignOnParticipationStrategies(RequestContext context) {
        return this.providers.stream().filter(p -> p.supports(context)).collect(Collectors.toList());
    }

    @Generated
    public ChainingSingleSignOnParticipationStrategy() {
    }
}

