/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DefaultSingleSignOnParticipationStrategy
implements SingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleSignOnParticipationStrategy.class);
    private final ServicesManager servicesManager;
    private final boolean createCookieOnRenewedAuthentication;
    private final boolean renewEnabled;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final AuthenticationServiceSelectionPlan serviceSelectionStrategy;
    private int order = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipating(RequestContext requestContext) {
        if (this.renewEnabled && requestContext.getRequestParameters().contains("renew")) {
            LOGGER.debug("[{}] is specified for the request. The authentication session will be considered renewed.", (Object)"renew");
            return false;
        }
        RegisteredService registeredService = this.determineRegisteredService(requestContext);
        if (registeredService == null) {
            return true;
        }
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Authentication ca = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
        try {
            String tgtId;
            TicketState ticketState;
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
            boolean isAllowedForSso = registeredService.getAccessStrategy().isServiceAccessAllowedForSso();
            LOGGER.trace("Located [{}] in registry. Service access to participate in SSO is set to [{}]", (Object)registeredService.getServiceId(), (Object)isAllowedForSso);
            if (!isAllowedForSso) {
                LOGGER.debug("Service [{}] is not authorized to participate in SSO", (Object)registeredService.getServiceId());
                boolean bl = false;
                return bl;
            }
            RegisteredServiceSingleSignOnParticipationPolicy ssoPolicy = registeredService.getSingleSignOnParticipationPolicy();
            if (ssoPolicy != null && (ticketState = this.ticketRegistrySupport.getTicketState(tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext))) != null) {
                boolean bl = ssoPolicy.shouldParticipateInSso(ticketState);
                return bl;
            }
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ca);
        }
        return true;
    }

    private RegisteredService determineRegisteredService(RequestContext requestContext) {
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        if (registeredService != null) {
            return registeredService;
        }
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        Service serviceToUse = this.serviceSelectionStrategy.resolveService((Service)service);
        if (serviceToUse != null) {
            return this.servicesManager.findServiceBy(serviceToUse);
        }
        return null;
    }

    public boolean isCreateCookieOnRenewedAuthentication(RequestContext context) {
        return this.createCookieOnRenewedAuthentication;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public boolean isCreateCookieOnRenewedAuthentication() {
        return this.createCookieOnRenewedAuthentication;
    }

    @Generated
    public boolean isRenewEnabled() {
        return this.renewEnabled;
    }

    @Generated
    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }

    @Generated
    public AuthenticationServiceSelectionPlan getServiceSelectionStrategy() {
        return this.serviceSelectionStrategy;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public DefaultSingleSignOnParticipationStrategy(ServicesManager servicesManager, boolean createCookieOnRenewedAuthentication, boolean renewEnabled, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.createCookieOnRenewedAuthentication = createCookieOnRenewedAuthentication;
        this.renewEnabled = renewEnabled;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

