/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowAbstractTicketExceptionHandler
implements CasWebflowExceptionHandler<AbstractTicketException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowAbstractTicketExceptionHandler.class);
    private int order = Integer.MAX_VALUE;
    private final Set<Class<? extends Throwable>> errors;
    private final String messageBundlePrefix;

    @Override
    public Event handle(AbstractTicketException exception, RequestContext requestContext) {
        String id = this.handleAbstractTicketException(exception, requestContext);
        return new EventFactorySupport().event((Object)this, id);
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception instanceof AbstractTicketException;
    }

    protected String handleAbstractTicketException(AbstractTicketException e, RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        Optional<String> match = this.errors.stream().filter(c -> c.isInstance(e)).map(Class::getSimpleName).findFirst();
        MessageResolver msg = new MessageBuilder().error().code(e.getCode()).args(e.getArgs().toArray()).build();
        match.ifPresent(s -> messageContext.addMessage(msg));
        return match.orElse("UNKNOWN");
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public Set<Class<? extends Throwable>> getErrors() {
        return this.errors;
    }

    @Generated
    public String getMessageBundlePrefix() {
        return this.messageBundlePrefix;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public DefaultCasWebflowAbstractTicketExceptionHandler(Set<Class<? extends Throwable>> errors, String messageBundlePrefix) {
        this.errors = errors;
        this.messageBundlePrefix = messageBundlePrefix;
    }
}

