/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowAuthenticationExceptionHandler
implements CasWebflowExceptionHandler<AuthenticationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowAuthenticationExceptionHandler.class);
    private int order = Integer.MAX_VALUE;
    private final Set<Class<? extends Throwable>> errors;
    private final String messageBundlePrefix;

    @Override
    public Event handle(AuthenticationException exception, RequestContext requestContext) {
        String id = this.handleAuthenticationException(exception, requestContext);
        return new EventFactorySupport().event((Object)this, id);
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception instanceof AuthenticationException;
    }

    protected String handleAuthenticationException(AuthenticationException e, RequestContext requestContext) {
        URI url;
        if (e.getHandlerErrors().containsKey(UnauthorizedServiceForPrincipalException.class.getSimpleName()) && (url = WebUtils.getUnauthorizedRedirectUrlFromFlowScope((RequestContext)requestContext)) != null) {
            LOGGER.warn("Unauthorized service access for principal; CAS will be redirecting to [{}]", (Object)url);
            return "serviceUnauthorizedCheck";
        }
        List values = e.getHandlerErrors().values().stream().map(Object::getClass).collect(Collectors.toList());
        String handlerErrorName = this.errors.stream().filter(values::contains).map(Class::getSimpleName).findFirst().orElseGet(() -> {
            LOGGER.debug("Unable to translate handler errors of the authentication exception [{}]. Returning [{}]", (Object)e, (Object)"UNKNOWN");
            return "UNKNOWN";
        });
        MessageContext messageContext = requestContext.getMessageContext();
        String messageCode = this.messageBundlePrefix + handlerErrorName;
        MessageResolver message = new MessageBuilder().error().code(messageCode).args(new Object[]{e.getArgs()}).build();
        messageContext.addMessage(message);
        return handlerErrorName;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public Set<Class<? extends Throwable>> getErrors() {
        return this.errors;
    }

    @Generated
    public String getMessageBundlePrefix() {
        return this.messageBundlePrefix;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public DefaultCasWebflowAuthenticationExceptionHandler(Set<Class<? extends Throwable>> errors, String messageBundlePrefix) {
        this.errors = errors;
        this.messageBundlePrefix = messageBundlePrefix;
    }
}

