/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.cryptacular.util.CodecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;

public class ClientFlowExecutionKey
extends FlowExecutionKey {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientFlowExecutionKey.class);
    private static final String KEY_FORMAT = "<uuid>_<base64-encoded-flow-state>";
    private static final long serialVersionUID = 3514659327458916297L;
    private UUID id;
    private byte[] data;

    public ClientFlowExecutionKey(byte[] data) {
        this(UUID.randomUUID(), data);
    }

    public ClientFlowExecutionKey(UUID id, byte[] data) {
        Assert.notNull((Object)id, (String)"Flow execution id cannot be null.");
        this.id = id;
        this.data = data;
    }

    public static ClientFlowExecutionKey parse(String key) throws BadlyFormattedFlowExecutionKeyException {
        List tokens = Splitter.on((char)'_').splitToList((CharSequence)key);
        if (tokens.size() != 2) {
            throw new BadlyFormattedFlowExecutionKeyException(key, KEY_FORMAT);
        }
        try {
            UUID uuid = UUID.fromString((String)tokens.get(0));
            byte[] decoded = CodecUtil.b64((CharSequence)((CharSequence)tokens.get(1)));
            return new ClientFlowExecutionKey(uuid, decoded);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadlyFormattedFlowExecutionKeyException(key, KEY_FORMAT);
        }
    }

    public String toString() {
        return this.id + "_" + CodecUtil.b64((byte[])this.data);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ClientFlowExecutionKey temp = ClientFlowExecutionKey.parse(in.readUTF());
        this.id = temp.id;
        this.data = temp.data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientFlowExecutionKey)) {
            return false;
        }
        ClientFlowExecutionKey other = (ClientFlowExecutionKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.id;
        UUID other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientFlowExecutionKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + Arrays.hashCode(this.data);
        return result;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }
}

