/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.web.flow.executor.Transcoder;
import org.cryptacular.bean.CipherBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public class EncryptedTranscoder
implements Transcoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedTranscoder.class);
    private CipherBean cipherBean;
    private boolean compression = true;

    public EncryptedTranscoder(CipherBean cipherBean) {
        this.setCipherBean(cipherBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(Object o) throws IOException {
        if (o == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = this.compression ? new ObjectOutputStream(new GZIPOutputStream(outBuffer)) : new ObjectOutputStream(outBuffer);
            this.writeObjectToOutputStream(o, out);
        }
        catch (NotSerializableException e) {
            try {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
        return this.encrypt(outBuffer);
    }

    protected void writeObjectToOutputStream(Object o, ObjectOutputStream out) throws IOException {
        Object object = o;
        if (AopUtils.isAopProxy((Object)o)) {
            try {
                object = ((Advised)Advised.class.cast(o)).getTargetSource().getTarget();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (object == null) {
                LOGGER.error("Could not determine object [{}] from proxy", (Object)o.getClass().getSimpleName());
            }
        }
        if (object != null) {
            out.writeObject(object);
        } else {
            LOGGER.warn("Unable to write object [{}] to the output stream", o);
        }
    }

    protected byte[] encrypt(ByteArrayOutputStream outBuffer) throws IOException {
        try {
            return this.cipherBean.encrypt(outBuffer.toByteArray());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException("Encryption error", e);
        }
    }

    @Override
    public Object decode(byte[] encoded) throws IOException {
        Object object;
        byte[] data;
        try {
            data = this.cipherBean.decrypt(encoded);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException("Decryption error", e);
        }
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = this.compression ? new ObjectInputStream(new GZIPInputStream(inBuffer)) : new ObjectInputStream(inBuffer);
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IOException("Deserialization error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return object;
    }

    @Generated
    public void setCipherBean(CipherBean cipherBean) {
        this.cipherBean = cipherBean;
    }

    @Generated
    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    @Generated
    public EncryptedTranscoder() {
    }
}

